/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.maps;

import binnavi.plugins.gadgetfinder.datastructures.ComparableReilOperand;
import binnavi.plugins.gadgetfinder.datastructures.tree.LinkedBinaryTree;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OperandTreeMap
implements Serializable {
    private static final long serialVersionUID = 4312050047913784565L;
    private final Map<ComparableReilOperand, LinkedBinaryTree<ComparableReilOperand>> m_operandTrees = new HashMap<ComparableReilOperand, LinkedBinaryTree<ComparableReilOperand>>();

    public boolean containsTree(ComparableReilOperand key) {
        return this.m_operandTrees.containsKey(key);
    }

    public void deleteAllTrees() {
        this.m_operandTrees.clear();
    }

    public LinkedBinaryTree<ComparableReilOperand> deleteTree(ComparableReilOperand key) {
        return this.m_operandTrees.remove(key);
    }

    public Set<Map.Entry<ComparableReilOperand, LinkedBinaryTree<ComparableReilOperand>>> entrySet() {
        return this.m_operandTrees.entrySet();
    }

    public boolean equals(OperandTreeMap operandTreeMap) {
        if (this.size() != operandTreeMap.size()) {
            return false;
        }
        for (Map.Entry<ComparableReilOperand, LinkedBinaryTree<ComparableReilOperand>> element : operandTreeMap.entrySet()) {
            if (this.containsTree(element.getKey())) {
                LinkedBinaryTree<ComparableReilOperand> checkTree;
                LinkedBinaryTree<ComparableReilOperand> thisTree = this.getTree(element.getKey());
                if (thisTree.equals(checkTree = operandTreeMap.getTree(element.getKey()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public LinkedBinaryTree<ComparableReilOperand> getTree(ComparableReilOperand comparableReilOperand) {
        if (comparableReilOperand == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_operandTrees.containsKey(comparableReilOperand)) {
            return this.m_operandTrees.get(comparableReilOperand).clone();
        }
        if ("TRUE".equals(comparableReilOperand.getElement().getValue()) || "FALSE".equals(comparableReilOperand.getElement().getValue())) {
            throw new IllegalStateException();
        }
        LinkedBinaryTree<ComparableReilOperand> emptyBinaryTree = new LinkedBinaryTree<ComparableReilOperand>();
        emptyBinaryTree.addRoot(comparableReilOperand);
        return emptyBinaryTree;
    }

    public Collection<LinkedBinaryTree<ComparableReilOperand>> getTrees() {
        return this.m_operandTrees.values();
    }

    public boolean isEmpty() {
        return this.m_operandTrees.isEmpty();
    }

    public Set<ComparableReilOperand> keySet() {
        return this.m_operandTrees.keySet();
    }

    public int size() {
        return this.m_operandTrees.size();
    }

    public void storeTree(ComparableReilOperand ComparableReilOperand2, LinkedBinaryTree<ComparableReilOperand> expressionTree) {
        this.m_operandTrees.put(ComparableReilOperand2, expressionTree);
    }

    public String toString() {
        String result = new String();
        for (ComparableReilOperand key : this.m_operandTrees.keySet()) {
            result = String.valueOf(result) + "KEY -> [" + key + "] \nTREE -> \n" + this.m_operandTrees.get(key).toString();
        }
        return result;
    }
}

