/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.datastructures.tree;

import binnavi.plugins.gadgetfinder.datastructures.list.Interfaces.PositionList;
import binnavi.plugins.gadgetfinder.datastructures.list.NodePositionList;
import binnavi.plugins.gadgetfinder.datastructures.node.BTNode;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.BTPosition;
import binnavi.plugins.gadgetfinder.datastructures.node.Interfaces.Position;
import binnavi.plugins.gadgetfinder.datastructures.tree.Interfaces.BinaryTree;
import binnavi.plugins.gadgetfinder.helper.BoundaryViolationException;
import binnavi.plugins.gadgetfinder.helper.EmptyTreeException;
import binnavi.plugins.gadgetfinder.helper.InvalidPositionException;
import binnavi.plugins.gadgetfinder.helper.NonEmptyTreeException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class LinkedBinaryTree<E>
implements BinaryTree<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1813128177963930417L;
    protected BTPosition<E> root = null;
    public int size = 0;

    private void clone(LinkedBinaryTree<E> cloneTree, BTPosition<E> current, BTPosition<E> originalCurrent) {
        if (originalCurrent.getLeft() != null) {
            cloneTree.insertLeft(current, originalCurrent.getLeft().element());
            this.clone(cloneTree, current.getLeft(), originalCurrent.getLeft());
        }
        if (originalCurrent.getRight() != null) {
            cloneTree.insertRight(current, originalCurrent.getRight().element());
            this.clone(cloneTree, current.getRight(), originalCurrent.getRight());
        }
    }

    private String deleteLastChar(String s) {
        return s.substring(0, s.length() - 1);
    }

    protected BTPosition<E> createNode(E element, BTPosition<E> parent, BTPosition<E> left, BTPosition<E> right) {
        return new BTNode<E>(element, parent, left, right);
    }

    protected void inorderPositions(Position<E> v, PositionList<Position<E>> pos) throws InvalidPositionException {
        if (this.hasLeft(v)) {
            this.inorderPositions(this.left(v), pos);
        }
        pos.addLast(v);
        if (this.hasRight(v)) {
            this.inorderPositions(this.right(v), pos);
        }
    }

    protected void preorderPositions(Position<E> v, PositionList<Position<E>> pos) throws InvalidPositionException {
        pos.addLast(v);
        if (this.hasLeft(v)) {
            this.preorderPositions(this.left(v), pos);
        }
        if (this.hasRight(v)) {
            this.preorderPositions(this.right(v), pos);
        }
    }

    public Position<E> addRoot(E e) throws NonEmptyTreeException {
        if (!this.isEmpty()) {
            throw new NonEmptyTreeException("Tree already has a root node");
        }
        this.size = 1;
        this.root = this.createNode(e, null, null, null);
        return this.root;
    }

    public void attach(Position<E> v, LinkedBinaryTree<E> T1, LinkedBinaryTree<E> T2) throws InvalidPositionException {
        if (this.isInternal(v)) {
            throw new InvalidPositionException("Cannot attach from internal node");
        }
        this.attachLeft(v, T1);
        this.attachRight(v, T2);
    }

    public void attachLeft(Position<E> v, LinkedBinaryTree<E> T1) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        if (this.hasLeft(v)) {
            throw new InvalidPositionException("Cannot attachLeft from node with left child");
        }
        if (T1 != null && !T1.isEmpty()) {
            Object cloneT1 = T1.clone();
            BTPosition<E> r1 = this.checkPosition(((LinkedBinaryTree)cloneT1).root());
            vv.setLeft(r1);
            r1.setParent(vv);
            this.size += ((LinkedBinaryTree)cloneT1).size();
        }
    }

    public void attachRight(Position<E> v, LinkedBinaryTree<E> T1) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        if (this.hasRight(v)) {
            throw new InvalidPositionException("Cannot attachRight from node with right child");
        }
        if (T1 != null && !T1.isEmpty()) {
            Object cloneT1 = T1.clone();
            BTPosition<E> r1 = this.checkPosition(((LinkedBinaryTree)cloneT1).root());
            vv.setRight(r1);
            r1.setParent(vv);
            this.size += ((LinkedBinaryTree)cloneT1).size();
        }
    }

    public LinkedBinaryTree<E> buildSubtree(Position<E> v) {
        LinkedBinaryTree<E> subtree = new LinkedBinaryTree<E>();
        BTPosition<E> origTreeProsition = this.checkPosition(v);
        subtree.addRoot(v.element());
        this.clone(subtree, subtree.root, origTreeProsition);
        return subtree;
    }

    public BTPosition<E> checkPosition(Position<E> v) throws InvalidPositionException {
        if (v == null || !(v instanceof BTPosition)) {
            throw new InvalidPositionException("the position is invalid");
        }
        return (BTPosition)v;
    }

    @Override
    public Iterable<Position<E>> children(Position<E> v) throws InvalidPositionException {
        NodePositionList<Position<Position<E>>> children = new NodePositionList<Position<Position<E>>>();
        if (this.hasLeft(v)) {
            children.addLast(this.left(v));
        }
        if (this.hasRight(v)) {
            children.addLast(this.right(v));
        }
        return children;
    }

    public LinkedBinaryTree<E> clone() {
        if (this.isEmpty()) {
            return new LinkedBinaryTree<E>();
        }
        LinkedBinaryTree cloneTree = new LinkedBinaryTree();
        cloneTree.addRoot(this.root.element());
        this.clone(cloneTree, cloneTree.root, this.root);
        return cloneTree;
    }

    public boolean contains(E o) {
        for (Position<E> position : this.positions()) {
            if (!position.element().equals(o)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(LinkedBinaryTree<E> t) {
        if (t.isEmpty() && this.isEmpty()) {
            return true;
        }
        NodePositionList<Position<Position<E>>> thisTreeList = new NodePositionList<Position<Position<E>>>();
        NodePositionList<Position<E>> checkTreeList = new NodePositionList<Position<E>>();
        this.preorderPositions(this.root(), thisTreeList);
        this.preorderPositions(t.root(), checkTreeList);
        return thisTreeList.equals(checkTreeList);
    }

    public void expandExternal(Position<E> v, E l, E r) throws InvalidPositionException {
        if (!this.isExternal(v)) {
            throw new InvalidPositionException("Node is not external");
        }
        this.insertLeft(v, l);
        this.insertRight(v, r);
    }

    public ArrayList<Position<E>> find(E o) {
        ArrayList<Position<Position<E>>> elementPostitions = new ArrayList<Position<Position<E>>>();
        for (Position<E> position : this.positions()) {
            if (!position.element().equals(o)) continue;
            elementPostitions.add(position);
        }
        return elementPostitions;
    }

    @Override
    public boolean hasLeft(Position<E> v) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        return vv.getLeft() != null;
    }

    public boolean hasParent(Position<E> v) {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> parentPos = vv.getParent();
        return parentPos != null;
    }

    @Override
    public boolean hasRight(Position<E> v) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        return vv.getRight() != null;
    }

    public BTPosition<E> insertLeft(Position<E> v, E e) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> leftPos = vv.getLeft();
        if (leftPos != null) {
            throw new InvalidPositionException("Node already has a left child");
        }
        BTPosition<E> ww = this.createNode(e, vv, null, null);
        vv.setLeft(ww);
        ++this.size;
        return ww;
    }

    public BTPosition<E> insertRight(Position<E> v, E e) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> rightPos = vv.getRight();
        if (rightPos != null) {
            throw new InvalidPositionException("Node already has a right child");
        }
        BTPosition<E> ww = this.createNode(e, vv, null, null);
        vv.setRight(ww);
        ++this.size;
        return ww;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean isExternal(Position<E> v) throws InvalidPositionException {
        return !this.isInternal(v);
    }

    @Override
    public boolean isInternal(Position<E> v) throws InvalidPositionException {
        this.checkPosition(v);
        return this.hasLeft(v) || this.hasRight(v);
    }

    @Override
    public boolean isRoot(Position<E> v) throws InvalidPositionException {
        this.checkPosition(v);
        return v == this.root();
    }

    @Override
    public Iterator<E> iterator() {
        Iterable<Position<E>> positions = this.positions();
        NodePositionList<E> elements = new NodePositionList<E>();
        for (Position<E> pos : positions) {
            elements.addLast(pos.element());
        }
        return elements.iterator();
    }

    @Override
    public Position<E> left(Position<E> v) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> leftPos = vv.getLeft();
        if (leftPos == null) {
            throw new BoundaryViolationException("Node has no left Child");
        }
        return leftPos;
    }

    public void levelorderPositions(Position<E> v, PositionList<Position<E>> pos) throws InvalidPositionException {
        ArrayDeque<Position<E>> queue = new ArrayDeque<Position<E>>();
        queue.add(v);
        while (!queue.isEmpty()) {
            Position position = (Position)queue.poll();
            pos.addLast(position);
            if (this.hasLeft(position)) {
                queue.add(this.left(position));
            }
            if (!this.hasRight(position)) continue;
            queue.add(this.right(position));
        }
    }

    @Override
    public Position<E> parent(Position<E> v) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> parentPos = vv.getParent();
        if (parentPos == null) {
            throw new BoundaryViolationException("No has no parent");
        }
        return parentPos;
    }

    @Override
    public Iterable<Position<E>> positions() {
        NodePositionList<Position<E>> positions = new NodePositionList<Position<E>>();
        if (this.size != 0) {
            this.preorderPositions(this.root(), positions);
        }
        return positions;
    }

    public String print(boolean isLeft, String indent, Position<E> v) {
        String nodeDisplay = v.element().toString();
        String returnString = "";
        returnString = isLeft ? String.valueOf(returnString) + indent + "__" + nodeDisplay + "\n" : String.valueOf(returnString) + this.deleteLastChar(indent) + "|__" + nodeDisplay + "\n";
        if (this.isExternal(v) && !isLeft) {
            returnString = String.valueOf(returnString) + this.deleteLastChar(indent) + "\n";
        }
        if (this.isExternal(v)) {
            return returnString;
        }
        indent = isLeft ? String.valueOf(indent) + "  |" : String.valueOf(this.deleteLastChar(indent)) + "   |";
        returnString = !this.hasLeft(v) ? String.valueOf(returnString) + indent + "__null\n" : String.valueOf(returnString) + this.print(true, indent, this.left(v));
        returnString = !this.hasRight(v) ? String.valueOf(returnString) + indent + "__null\n" : String.valueOf(returnString) + this.print(false, indent, this.right(v));
        return returnString;
    }

    public E remove(Position<E> v) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> leftPos = vv.getLeft();
        BTPosition<E> rightPos = vv.getRight();
        if (leftPos != null && rightPos != null) {
            throw new InvalidPositionException("cannot remove node with two children");
        }
        BTPosition<E> ww = leftPos != null ? leftPos : (rightPos != null ? rightPos : null);
        if (vv == this.root) {
            if (ww != null) {
                ww.setParent(null);
            }
            this.root = ww;
        } else {
            BTPosition<E> uu = vv.getParent();
            if (vv == uu.getLeft()) {
                uu.setLeft(ww);
            } else {
                uu.setRight(ww);
            }
            if (ww != null) {
                ww.setParent(uu);
            }
        }
        --this.size;
        return v.element();
    }

    public void removeAboveExternal(Position<E> v) throws InvalidPositionException {
        if (!this.isExternal(v)) {
            throw new InvalidPositionException("Node is not external");
        }
        if (this.isRoot(v)) {
            this.remove(v);
        } else {
            Position<E> u = this.parent(v);
            this.remove(v);
            this.remove(u);
        }
    }

    @Override
    public E replace(Position<E> v, E o) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        E temp = v.element();
        vv.setElement(o);
        return temp;
    }

    @Override
    public Position<E> right(Position<E> v) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> rightPos = vv.getRight();
        if (rightPos == null) {
            throw new BoundaryViolationException("No right child");
        }
        return rightPos;
    }

    @Override
    public Position<E> root() throws EmptyTreeException {
        if (this.root == null) {
            throw new EmptyTreeException("The tree is empty");
        }
        return this.root;
    }

    public Position<E> sibling(Position<E> v) throws InvalidPositionException, BoundaryViolationException {
        BTPosition<E> leftPos;
        BTPosition<E> sibPos;
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> parentPos = vv.getParent();
        if (parentPos != null && (sibPos = (leftPos = parentPos.getLeft()) == vv ? parentPos.getRight() : parentPos.getLeft()) != null) {
            return sibPos;
        }
        throw new BoundaryViolationException("Node has no sibling");
    }

    @Override
    public int size() {
        return this.size;
    }

    public void swapElements(Position<E> v, Position<E> w) throws InvalidPositionException {
        BTPosition<E> vv = this.checkPosition(v);
        BTPosition<E> ww = this.checkPosition(w);
        E temp = w.element();
        ww.setElement(v.element());
        vv.setElement(temp);
    }

    public String toString() {
        return this.print(true, "", this.root);
    }
}

