/*
 * Decompiled with CFR 0.152.
 */
package binnavi.plugins.gadgetfinder.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GuiHelper {
    public static final void centerChildToParent(Component parent, Component child, boolean bStayOnScreen) {
        int x = parent.getX() + parent.getWidth() / 2 - child.getWidth() / 2;
        int y = parent.getY() + parent.getHeight() / 2 - child.getHeight() / 2;
        if (bStayOnScreen) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension ss = new Dimension(tk.getScreenSize());
            if ((double)(x + child.getWidth()) > ss.getWidth()) {
                x = (int)(ss.getWidth() - (double)child.getWidth());
            }
            if ((double)(y + child.getHeight()) > ss.getHeight()) {
                y = (int)(ss.getHeight() - (double)child.getHeight());
            }
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
        }
        child.setLocation(x, y);
    }

    public static final void centerOnScreen(Window frame) {
        frame.setLocationRelativeTo(null);
    }

    public static String getDefaultFont() {
        Font[] allfonts;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = allfonts = env.getAllFonts();
        int n = allfonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            if (font.getName().equals("Arial")) {
                return "Arial";
            }
            ++n2;
        }
        return "Serif";
    }

    public static String getMonospaceFont() {
        Font[] allfonts;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = allfonts = env.getAllFonts();
        int n = allfonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            if (font.getName().equals("Courier New")) {
                return "Courier New";
            }
            ++n2;
        }
        return "Monospaced";
    }

    public static Window getOwnerWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    public static void updateUI(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                component.updateUI();
            }
        });
    }
}

