#ifndef DEBUGEXCEPTIONS_HPP
#define DEBUGEXCEPTIONS_HPP

#include "defs.hpp"
#include "DebugExceptionHandlingAction.hpp"
#include <vector>

/**
* Defines a platform specific exception which can occur while the debugger is running.
**/
struct DebugException 
{
	DebugException(const std::string& name, CPUADDRESS code, DebugExceptionHandlingAction action):
		exceptionName(name),
		exceptionCode(code),
		handlingAction(action) {}

	std::string exceptionName;
	CPUADDRESS exceptionCode;

	// defines how the debugger should handle this specific exception
	DebugExceptionHandlingAction handlingAction;
};

typedef std::vector<DebugException> DebugExceptionContainer;

#endif