#ifndef DEBUGGEROPTIONS_HPP
#define DEBUGGEROPTIONS_HPP

#include "DebugException.hpp"

/**
* Small struct that is used to specify the
* debug commands supported by a debug client.
**/
struct DebuggerOptions
{
	bool canDetach;
	bool canTerminate;
	bool canMemmap;
	bool canValidMemory;
	bool canMultithread;
	bool canSoftwareBreakpoint;
	int breakpointCount;
	bool canHalt;
	bool haltBeforeCommunicating;
	bool hasStack;
	int pageSize;

	// Specifies whether the debugger is able to handle breakpoint hit counts which are greater than one.
	bool canTraceCount;
	
	// Specifies that the debugger is able to halt the process whenever a library is mapped into the address space.
	bool canBreakOnModuleLoad;
	
	// Specifies that the debugger is able to halt the process whenever a library is unmapped from the address space.
	bool canBreakOnModuleUnload;
	
	// list of supported exceptions on the specific platform
	DebugExceptionContainer exceptions;
	
	DebuggerOptions() :
		canDetach(true),
		canTerminate(true),
		canMemmap(true),
		canValidMemory(true),
		canMultithread(true),
		canSoftwareBreakpoint(true),
		breakpointCount(-1),
		canHalt(false),
		haltBeforeCommunicating(false),
		hasStack(true),
		canTraceCount(true),
		pageSize(0),
		canBreakOnModuleLoad(true),
		canBreakOnModuleUnload(true)
	{ }
};

#endif
