#ifndef SIDEEFFECTACTION_H
#define SIDEEFFECTACTION_H

#include "defs.hpp"

/**
* Represents the type of action which possibly caused a side effect in the debugger.
**/
enum SideEffectAction { BreakpointDeleted };

/**
* Represents a side effect which occurred in a specific thread in the debugger
* and is thus possibly accountable for race conditions.
**/
struct SideEffect
{
	SideEffect(SideEffectAction action, unsigned int threadId, CPUADDRESS address) :
		threadId(threadId),
		action(action),
		address(address) {}

	unsigned int getThreadId() const { return threadId; }

	SideEffectAction getAction() const { return action; }

	CPUADDRESS getAddress() const { return address; }

	bool operator<(const SideEffect& rhs) const
	{
		return threadId < rhs.threadId && action < rhs.action;
	}

private:

	unsigned int threadId;
	SideEffectAction action;
	CPUADDRESS address;
};

#endif