#ifndef SIDEEFFECTMITIGATOR_H
#define SIDEEFFECTMITIGATOR_H

#include <iostream>
#include <set>
#include "SideEffectAction.h"

/**
* This class is used to keep track of actions which possibly cause side effects.
* After commands from BinNavi have been received, a possible side effect is added.
* As soon as the debugger detected that no side effect occurred/or resolved a side effect,
* the side effect is removed from the mitigator.
**/
class SideEffectmitigator
{
public:

	void addSideEffect(const SideEffect& effect);

	void removeSideEffect(const SideEffect& effect);

	void clearSideEffectsByThread(unsigned int threadId);

private:

	std::set<SideEffect> sideEffects;
};

#endif