#ifndef GENERICSOCKETFUNCTIONS_HPP
#define GENERICSOCKETFUNCTIONS_HPP

#ifdef NAVI_GDB_WINDOWS
#define SOME_GDB_AGENT
#elif NAVI_GDB_LINUX
#define SOME_GDB_AGENT
#elif NAVI_GDB_OSX
#define SOME_GDB_AGENT
#endif
	
	#ifdef NAVI_WINDBG_WINDOWS
	#include "WindowsSocket.hpp"
	
	#define LAST_ERROR_FUNCTION WSAGetLastError()
	
	#endif
	#ifdef NAVI_WINDOWS_SOCKET
	#include "WindowsSocket.hpp"
	
	#define LAST_ERROR_FUNCTION WSAGetLastError()
	#endif
	
	#ifdef NAVI_GDB_WINDOWS
	#include "WindowsSocket.hpp"

	#define LAST_ERROR_FUNCTION WSAGetLastError()
	#endif
	
	#ifdef NAVI_GDB_LINUX
	#include <errno.h>
	#include <sys/types.h>
	#include <netdb.h>
	#include "LinuxSocket.hpp"
	#define LAST_ERROR_FUNCTION errno
	#endif
    
    #ifdef NAVI_GDB_OSX
    #include <errno.h>
    #include <sys/types.h>
    #include <netdb.h>
    #include "OsxSocket.hpp"
    #define LAST_ERROR_FUNCTION errno
    #endif

	#ifdef NAVI_WINCE_SOCKET
	#include "WinCESocket.hpp"

	#define LAST_ERROR_FUNCTION WSAGetLastError()
	#endif
	
	#ifdef NAVI_LINUX_SOCKET
	#include <errno.h>
	#include <sys/types.h>
	#include <netdb.h>
	#include "LinuxSocket.hpp"
	#define LAST_ERROR_FUNCTION errno
	#endif
	
namespace SocketFunctions
{
	bool hasData(SOCKET socket);
	
	NaviError read(SOCKET socket, char* buffer, unsigned int size);
	
	unsigned int send(SOCKET socket, const char* buffer, unsigned int size);
	
#ifdef SOME_GDB_AGENT
	SOCKET connect(const std::string& host, unsigned int port);

	void close(SOCKET socket);
#endif
}

#endif
