#ifndef INCLUDER_HPP
#define INCLUDER_HPP

#ifdef NAVI_WINDOWS_SOCKET
	#include "conns/WindowsSocket.hpp"
	#include "windows/WindowsSystem.hpp"
	#include "windows/misc.hpp"
	
	#define CONNECTION_POLICY WindowsSocket
	#define SYSTEM_POLICY WindowsSystem
#endif

#ifdef NAVI_WINCE_SOCKET
	#include "wince/WinCESystem.hpp"
	#include "conns/WinCESocket.hpp"
	
	#define CONNECTION_POLICY WinCESocket
	#define SYSTEM_POLICY WinCESystem
#endif

#ifdef NAVI_LINUX_SOCKET
	#include "linux/LinuxSystem.hpp"
	#include "conns/LinuxSocket.hpp"
	#include "linux/misc.hpp"

	#define CONNECTION_POLICY LinuxSocket
	#define SYSTEM_POLICY LinuxSystem	
#endif

#ifdef NAVI_GDB_WINDOWS
	#include "gdb/GdbSystem.hpp"
	#include "conns/WindowsSocket.hpp"
	#include "gdb/misc.hpp"

	#define CONNECTION_POLICY WindowsSocket
	#define SYSTEM_POLICY GdbSystem
#endif

#ifdef NAVI_GDB_LINUX
	#include "gdb/GdbSystem.hpp"
	#include "conns/LinuxSocket.hpp"
	#include "gdb/misc.hpp"

	#define CONNECTION_POLICY LinuxSocket
	#define SYSTEM_POLICY GdbSystem
#endif

#ifdef NAVI_GDB_OSX
    #include "gdb/GdbSystem.hpp"
    #include "conns/OSXSocket.hpp"
    #include "gdb/misc.hpp"

    #define CONNECTION_POLICY OSXSocket
    #define SYSTEM_POLICY GdbSystem
#endif

#ifdef NAVI_WINDBG_WINDOWS
	#include "windbg/WinDbgSystem.hpp"
	#include "conns/WindowsSocket.hpp"
	#include "windbg/misc.hpp"

	#define CONNECTION_POLICY WindowsSocket
	#define SYSTEM_POLICY WinDbgSystem
#endif

#ifndef SYSTEM_POLICY
	#error No System Policy selected
#endif

#ifndef CONNECTION_POLICY
	#error No Connection Policy selected
#endif

#endif
