#include "NTHeader.h"
#include <string>

#define MakePtr( cast, ptr, addValue ) (cast)( (DWORD_PTR)(ptr) + (DWORD_PTR)(addValue))

NTHeader::NTHeader(std::string fileName) :
	pNTHeader_(NULL),
	imageSize(0)
{
	parsePEFile(fileName);
}

NTHeader::~NTHeader()
{
	UnmapViewOfFile(mappedView_);
	CloseHandle(hFileMapping_);
	CloseHandle(hFile_);
}

void NTHeader::parsePEFile(const std::string& fileName)
{
	hFile_ = CreateFile(fileName.c_str(), GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if (hFile_ == INVALID_HANDLE_VALUE)
		throw std::exception("Unable to open file!");

	hFileMapping_ = CreateFileMapping(hFile_, NULL, PAGE_READONLY, 0, 0, NULL);
	if (hFileMapping_ == 0 )
	{
		CloseHandle(hFile_);
		throw std::runtime_error("Unable to create file mapping for PE file (" + fileName + ")");
	}

	mappedView_ = (PBYTE)MapViewOfFile(hFileMapping_, FILE_MAP_READ, 0, 0, 0);
	if (mappedView_ == 0)
	{
		CloseHandle(hFileMapping_);
		CloseHandle(hFile_);
		throw std::runtime_error("Unable to map view of file!");
	}

	PIMAGE_DOS_HEADER pDosHeader = (PIMAGE_DOS_HEADER)mappedView_;	
	if (IsBadReadPtr(mappedView_, sizeof(IMAGE_DOS_HEADER)))
	{
		throw new std::runtime_error("Unable to parse DOS header of debug executable (" + fileName + ")");
	}
	
	pNTHeader_ = MakePtr(PIMAGE_NT_HEADERS, pDosHeader, pDosHeader->e_lfanew);

	if (IsBadReadPtr(pNTHeader_, sizeof(IMAGE_NT_HEADERS)))
	{
		throw new std::runtime_error("Unable to parse PE header of debug executable (" + fileName + ")");
	}
	
	imageSize = pNTHeader_->OptionalHeader.SizeOfImage;
}