#pragma once

/**
* Common functionality for the windows debuggers (i.e. winDbg (kernel) and std windows debug client).
**/

#include "../errors.hpp"

/**
* Note: it is *very* important to specify the boost version here; otherwise different translation units might use different boost versions.
* This can lead to very subtle implicit conversion erros.
**/
#define BOOST_FILESYSTEM_VERSION 3
#include <boost/filesystem.hpp>
#include <vector>

namespace windowscommon
{
	extern "C" NaviError getFileSystems(std::vector<boost::filesystem::path>& roots);	

	extern "C" NaviError getSystemRoot(boost::filesystem::path& root);
}