#ifndef FILETARGET_HPP
#define FILETARGET_HPP

#include <fstream>
#include <string>
#include "ilogtarget.h"

namespace zylib
{
	namespace zylog
	{
		/**
		* Logger target that logs messages to a file.
		**/
		class FileTarget : public ILogTarget
		{
			private:
				std::string filename;
				std::ofstream file;
				
			public:
				/**
				* \brief Creates a new file target.
				*
				* Creates a new file target.
				*
				* @param filename Name of the logfile.
				**/
				explicit FileTarget(const std::string& filename);
				
				/**
				* \brief Writes a message to the file.
				*
				* Writes a message to the file.
				**/
				void log(const char* msg);
		};
	}
}

#endif

