#ifndef LISTBOXWMTARGET_HPP
#define LISTBOXWMTARGET_HPP

#include <windowsx.h>
#include <windows.h>
#include <zylog/src/ILogTarget.hpp>

namespace zylib
{
	namespace zylog
	{
		/**
		* Logger target that logs messages to a file.
		**/
		class ListBoxTarget : public ILogTarget
		{
			private:
				HWND hListBox;
				
			public:
				/**
				* \brief Creates a new listbox target.
				*
				* Creates a new listbox target.
				*
				* @param filename Name of the logfile.
				**/
				ListBoxTarget(const HWND hDlg, const int itemID);
				
				/**
				* \brief Writes a message to the file.
				*
				* Writes a message to the file.
				**/
				void log(const char* msg);
		};
	}
}

#endif