#include "logger.h"

#include <cstdarg>


#include "consoletarget.h"
#include "filetarget.h"


namespace zylib
{
	namespace zylog
	{
#ifdef WINCE
		enum { MAX_MSG= 100 };
		#define vsnprintf _vsnprintf
#else
		enum { MAX_MSG= 4096 };
#endif

		void Logger::addTarget(ILogTarget* target)
		{
			targets.push_back(target);
		}
				
		void Logger::log(unsigned int level, const char* message, ...)
		{
			if (level > logLevel)
			{
				return;
			}

			va_list arglist;
			char text[MAX_MSG];
			va_start( arglist, message );
#ifdef WIN32
			vsnprintf_s(text, MAX_MSG, _TRUNCATE, message, arglist);
#else
			vsnprintf( text, MAX_MSG, message, arglist );
#endif
			va_end( arglist );
	
			for (std::vector<ILogTarget*>::iterator Iter = targets.begin(); Iter != targets.end(); ++Iter)
			{
				(*Iter)->log(text);
			}
		}
	}
}
