package com.zynamics.binnavi.standardplugins.callresolver;

import java.util.ArrayList;
import java.util.List;

import BinNavi.API.debug.Debugger;
import BinNavi.API.disassembly.AddressSpace;
import BinNavi.API.disassembly.AddressSpaceListenerAdapter;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.View;

/**
 * This class encapsulates an address space to act like a call resolver target.
 */
public final class AddressSpaceCallResolverTarget implements ICallResolverTarget
{
	/**
	 * The encapsulated address space.
	 */
	private final AddressSpace addressSpace;

	/**
	 * Listeners that are notified about changes in the call resolver target.
	 */
	private final List<ICallResolverTargetListener> listeners = new ArrayList<ICallResolverTargetListener>();

	/**
	 * Converts events of the address space into events of the call resolver target.
	 */
	private final InternalAddressSpaceListener internalAddressSpaceListener = new InternalAddressSpaceListener();

	/**
	 * Creates a new call resolver target.
	 *
	 * @param addressSpace The encapsulated address space.
	 */
	public AddressSpaceCallResolverTarget(final AddressSpace addressSpace)
	{
		this.addressSpace = addressSpace;

		addressSpace.addListener(internalAddressSpaceListener);
	}

	@Override
	public void addListener(final ICallResolverTargetListener listener)
	{
		listeners.add(listener);
	}

	@Override
	public View createView()
	{
		return addressSpace.getProject().createView("Dynamic Trace View", "");
	}

	@Override
	public Debugger getDebugger()
	{
		return addressSpace.getDebugger();
	}

	@Override
	public List<IndirectCall> getIndirectCalls()
	{
		final List<IndirectCall> indirectCalls = new ArrayList<IndirectCall>();

		for (final Module module : addressSpace.getModules())
		{
			indirectCalls.addAll(IndirectCallFinder.find(module));
		}

		return indirectCalls;
	}

	@Override
	public List<Module> getModules()
	{
		return addressSpace.getModules();
	}

	@Override
	public void removeListener(final ICallResolverTargetListener listener)
	{
		listeners.remove(listener);
	}

	/**
	 * Converts events of the address space into events of the call resolver target.
	 */
	private class InternalAddressSpaceListener extends AddressSpaceListenerAdapter
	{
		// TODO: Handle closing address space

		@Override
		public void changedDebugger(final AddressSpace addressSpace, final Debugger debugger)
		{
			for (final ICallResolverTargetListener listener : listeners)
			{
				try
				{
					listener.changedDebugger(AddressSpaceCallResolverTarget.this, debugger);
				}
				catch(final Exception exception)
				{
					exception.printStackTrace();
				}
			}
		}
	}
}
