package com.zynamics.binnavi.standardplugins.callresolver;

import java.util.List;

import BinNavi.API.debug.Debugger;
import BinNavi.API.disassembly.Module;
import BinNavi.API.disassembly.View;

/**
 * Interface to be implemented by objects that want to act as call resolver targets.
 */
public interface ICallResolverTarget
{
	/**
	 * Adds a listener object that is notified about changes in the
	 * call resolver target.
	 *
	 * @param listener The listener object to add.
	 */
	void addListener(ICallResolverTargetListener listener);

	/**
	 * Creates a new view in the call resolver target.
	 *
	 * @return The created view.
	 */
	View createView();

	/**
	 * Returns the debugger that is used to debug the call resolver
	 * target.
	 *
	 * @return The active debugger.
	 */
	Debugger getDebugger();

	/**
	 * Returns the indirect calls of the call resolver target.
	 *
	 * @return The indirect calls of the call resolver target.
	 */
	List<IndirectCall> getIndirectCalls();

	/**
	 * Returns all modules that belong to the call resolver target.
	 *
	 * @return All modules that belong to the call resolver target.
	 */
	List<Module> getModules();

	/**
	 * Removes a listener object that was previously listening.
	 *
	 * @param listener The listener object to remove.
	 */
	void removeListener(ICallResolverTargetListener listener);
}
