package com.zynamics.binnavi.standardplugins.callresolver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import BinNavi.API.debug.MemoryModule;
import BinNavi.API.disassembly.Address;
import BinNavi.API.disassembly.Function;

/**
 * Generates the text that shows the resolved function calls in the dialog.
 */
public final class OutputListGenerator
{
	/**
	 * Sorts a set of resolved function calls by address of the source call.
	 *
	 * @param entries The list to sort.
	 *
	 * @return The sorted list.
	 */
	private static List<Entry<BigInteger, Set<ResolvedFunction>>> sort(final Set<Entry<BigInteger, Set<ResolvedFunction>>> entries)
	{
		final ArrayList<Entry<BigInteger, Set<ResolvedFunction>>> entryList = new ArrayList<Entry<BigInteger, Set<ResolvedFunction>>>(entries);

		Collections.sort(entryList, new Comparator<Entry<BigInteger, Set<ResolvedFunction>>>()
		{
			@Override
			public int compare(final Entry<BigInteger, Set<ResolvedFunction>> lhs, final Entry<BigInteger, Set<ResolvedFunction>> rhs)
			{
				return lhs.getKey().compareTo(rhs.getKey());
			}
		});

		return entryList;
	}

	/**
	 * Generates a string that shows the resolved functions.
	 *
	 * @param resolvedAddresses The function resolver result.
	 *
	 * @return The string that shows the resolved functions.
	 */
	public static String generate(final Map<BigInteger, Set<ResolvedFunction>> resolvedAddresses)
	{
		assert resolvedAddresses != null;

		final StringBuffer buffer = new StringBuffer();

		buffer.append("Resolved the following indirect calls:\n");

		for (final Entry<BigInteger, Set<ResolvedFunction>> element : sort(resolvedAddresses.entrySet()))
		{
			final BigInteger start = element.getKey();
			final Set<ResolvedFunction> targets = element.getValue();

			buffer.append(String.format("%08X ->\n", start.longValue()));

			for (final ResolvedFunction target : targets)
			{
				if (target.getFunction() != null)
				{
					final Function function = target.getFunction();

					final Address functionAddress = function.getAddress();
					final String functionName = function.getModule().getName() + "!" + function.getName();

					buffer.append(String.format("  %08X (%s)\n", functionAddress.toLong(), functionName));
				}
				else if (target.getMemoryModule() != null)
				{
					final MemoryModule module = target.getMemoryModule();

					final Address functionAddress = target.getAddress();
					final String functionName = module.getName() + "!???";

					buffer.append(String.format("  %08X (%s)\n", functionAddress.toLong(), functionName));
				}
				else
				{
					final Address address = target.getAddress();

					buffer.append(String.format("  %s (%s)\n", address.toHexString().toUpperCase(), "???!???"));
				}
			}
		}

		return buffer.toString();
	}
}
