package com.zynamics.binnavi.standardplugins.criterium;

import javax.swing.JPanel;

import BinNavi.API.disassembly.View2D;
import BinNavi.API.disassembly.ViewNode;
import BinNavi.API.helpers.GraphAlgorithms;
import BinNavi.API.plugins.ICriteriaSelectionPlugin;
import BinNavi.API.plugins.PluginInterface;

/**
 * This example plugin demonstrates how to extend the Select by Criteria dialog
 * in graph windows. The specific criterium implemented by the plugin is
 * to select all nodes inside loops.
 */
public class LoopSelectionCriteriumPlugin implements ICriteriaSelectionPlugin
{
	@Override
	public ICriterium getCriterium(final View2D view2D)
	{
		return new LoopCriterium();
	}

	@Override
	public String getCriteriumDescription()
	{
		return "Select Nodes in loops";
	}

	@Override
	public String getDescription()
	{
		return "Extends the Select by Criteria dialog to offer the option to select all nodes that are inside loops.";
	}

	@Override
	public long getGuid()
	{
		return 423749054235790534L;
	}

	@Override
	public String getName()
	{
		return "Loop Selection Plugin";
	}

	@Override
	public void init(final PluginInterface pluginInterface)
	{
	}

	@Override
	public void unload()
	{
	}

	/**
	 * Fixes the user configuration input of LoopCriterium objects. Since
	 * the loop criterium can not be configured, this object is stateless.
	 * For criteria that can be configured, this object would be passed
	 * all the necessary configuration values in the constructor.
	 */
	private static class EmptyFixedCriterium implements IFixedCriterium
	{
		@Override
		public boolean matches(final ViewNode node)
		{
			return GraphAlgorithms.getSuccessors(node).contains(node);
		}
	}

	/**
	 * Criterium class that describes individual criterium nodes in the
	 * Select by Criteria tree.
	 */
	private static class LoopCriterium implements ICriterium
	{
		/**
		 * Further configuration is not required => Show a simple standard panel.
		 */
		private final JPanel m_panel = new JPanel();

		@Override
		public String getCriteriumDescription()
		{
			return "Select Nodes in loops";
		}

		@Override
		public JPanel getCriteriumPanel()
		{
			return m_panel;
		}

		@Override
		public IFixedCriterium getFixedCriterium()
		{
			return new EmptyFixedCriterium();
		}

		@Override
		public String getFormulaString()
		{
			return "in loop";
		}

		@Override
		public boolean matches(final ViewNode node)
		{
			return GraphAlgorithms.getSuccessors(node).contains(node);
		}
	}
}
