package com.zynamics.binnavi.standardplugins.pathfinder;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JDialog;
import javax.swing.JTree;

import BinNavi.API.disassembly.Module;

import com.zynamics.binnavi.standardplugins.utils.IconNodeRenderer;
import com.zynamics.binnavi.standardplugins.utils.TreeHelpers;

/**
 * This class is used to show all functions and basic blocks
 * of a module in a tree structure.
 */
public final class FunctionTree extends JTree
{
	private static final long serialVersionUID = 6853860366467787695L;

	/**
	 * Creates a new function tree object.
	 *
	 * @param parent The function dialog where the tree is shown.
	 * @param module The module that provides the functions and basic blocks.
	 */
	public FunctionTree(final JDialog parent, final Module module)
	{
		setModel(new FilteredTreeModel(parent, module));

		setRootVisible(false);

		setCellRenderer(new IconNodeRenderer()); // ATTENTION: UNDER NO CIRCUMSTANCES MOVE THIS LINE ABOVE THE SETROOT LINE

		addMouseListener(new InternalMouseListener());
	}

	/**
	 * Passes double-click events to the nodes to handle them.
	 */
	private void handleDoubleClick(final MouseEvent event)
	{
		final IFunctionTreeNode selectedNode = (IFunctionTreeNode) TreeHelpers.getNodeAt(this, event.getX(), event.getY());

		if (selectedNode == null)
		{
			return;
		}

		selectedNode.doubleClicked();
	}

	public void dispose()
	{
		((FunctionTreeRootNode)getModel().getRoot()).dispose();
	}

	/**
	 * Handles double-clicks and right-clicks on nodes.
	 */
	private class InternalMouseListener extends MouseAdapter
	{
		@Override
		public void mouseClicked(final MouseEvent event)
		{
			if (event.getClickCount() == 2 && event.getButton() == MouseEvent.BUTTON1)
			{
				handleDoubleClick(event);
			}
		}
	}
}
