package com.zynamics.binnavi.standardplugins.pathfinder;

import javax.swing.ImageIcon;

import BinNavi.API.disassembly.BasicBlock;

/**
 * Represents basic blocks in the function tree.
 */
public final class FunctionTreeBlockNode extends FunctionTreeNode implements IFunctionTreeNode
{
	private static final ImageIcon ICON = new ImageIcon(PathfinderPlugin.class.getResource("resources/brick.png"));

	private static final long serialVersionUID = 8149820090579905872L;

	/**
	 * Basic block represented by the node.
	 */
	private final BasicBlock m_basicBlock;

	/**
	 * Creates a new block node object.
	 *
	 * @param basicBlock Basic block represented by the node.
	 */
	public FunctionTreeBlockNode(final BasicBlock basicBlock)
	{
		m_basicBlock = basicBlock;

		setIcon(ICON);
	}

	@Override
	public void doubleClicked()
	{
		// Do nothing when a basic block node is double clicked.
	}

	/**
	 * Returns the basic block represented by this node.
	 *
	 * @return The basic block represented by this node.
	 */
	public BasicBlock getBasicBlock()
	{
		return m_basicBlock;
	}

	@Override
	public boolean isVisible()
	{
		// always visible
		return true;
	}

	@Override
	public String toString()
	{
		return m_basicBlock.getAddress().toHexString();
	}
}
