package com.zynamics.binnavi.standardplugins.pathfinder;

import java.util.HashMap;
import java.util.Map;

import com.zynamics.binnavi.standardplugins.utils.IconNode;

/**
 * Base class for all tree nodes in the function tree
 * Every FunctionTreeNode applies the filter to all of its children
 */
public abstract class FunctionTreeNode extends IconNode implements IFilterableNode, IFunctionTreeNode
{
	private static final long serialVersionUID = -4517622668790112960L;

	/**
	 * The filter object which is passed to each node to determine visibility
	 */
	private TextPatternFilter m_filter;

	/**
	 * Cache node visibility in order to improve performance
	 */
	private final Map<FunctionTreeNode, Boolean> m_cachedVisibility = new HashMap<FunctionTreeNode, Boolean>();

	/**
	 * Let subclasses get the current filter for this node
	 * @return The currently set filter
	 */
	protected TextPatternFilter getFilter()
	{
		return m_filter;
	}

	@Override
	public FunctionTreeNode getChildAt(final int index)
	{
		int counter = 0;
		for (int i = 0; i < super.getChildCount(); i++)
		{
			final FunctionTreeNode node = (FunctionTreeNode)super.getChildAt(i);
			if (!m_cachedVisibility.containsKey(node))
			{
				m_cachedVisibility.put(node, node.isVisible());
			}

			if (m_cachedVisibility.get(node))
			{
				// node is visible so check if this is the node we are looking for...
				if (counter == index)
				{
					return node;
				}
				counter++;
			}
		}

		throw new IllegalStateException("Error: function tree node not found");
	}

	@Override
	public int getChildCount()
	{
		int counter = 0;
		for (int i = 0; i < super.getChildCount(); i++)
		{
			final FunctionTreeNode node = (FunctionTreeNode)super.getChildAt(i);
			if (!m_cachedVisibility.containsKey(node))
			{
				m_cachedVisibility.put(node, node.isVisible());
			}
			if (m_cachedVisibility.get(node))
			{
				counter++;
			}
		}
		return counter;
	}

	/**
	 * invalidate cached visibility and propagate filter to children
	 */
	@Override
	public void setFilter(final TextPatternFilter filter)
	{
		m_filter = filter;
		m_cachedVisibility.clear();

		for (int i = 0; i < super.getChildCount(); i++)
		{
			final FunctionTreeNode node = (FunctionTreeNode)super.getChildAt(i);
			node.setFilter(filter);
		}
	}
}
