package com.zynamics.binnavi.standardplugins.pathfinder;

/**
 * Each node which lends itself for simple text pattern based filtering needs to implement this interface
 */
public interface IFilterableNode
{
	/**
	 * The node can decide whether it should be visible or not (possibly via the filter mechanism)
	 * @return True if node should be visible, False otherwise
	 */
	boolean isVisible();

	/**
	 * set a new filter for the node
	 * @param filter The new filter object
	 */
	void setFilter(TextPatternFilter filter);
}
