package com.zynamics.binnavi.standardplugins.utils;


import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Taken from
 * http://www.crionics.com/products/opensource/faq/swing_ex/JTreeExamples4.html
 *
 * @version 1.1 06/19/99
 */
public class IconNode extends DefaultMutableTreeNode
{
	private static final long serialVersionUID = -7079996631145030853L;

	protected Icon icon;
	protected String iconName;

	public IconNode()
	{
		this(null);
	}

	public IconNode(final Object userObject)
	{
		this(userObject, true, null);
	}

	public IconNode(final Object userObject, final boolean allowsChildren, final Icon icon)
	{
		super(userObject, allowsChildren);
		this.icon = icon;
	}

	public final Icon getIcon()
	{
		return icon;
	}

	public final String getIconName()
	{
		if (iconName != null)
		{
			return iconName;
		}
		else
		{
			if (userObject == null)
			{
				return null;
			}
			else
			{
				final String str = userObject.toString();
				int index = str.lastIndexOf(".");
				if (index != -1)
				{
					return str.substring(++index);
				}
				else
				{
					return null;
				}
			}
		}
	}

	public final void setIcon(final Icon icon)
	{
		this.icon = icon;
	}

	public final void setIconName(final String name)
	{
		iconName = name;
	}

}
