package com.zynamics.binnavi.standardplugins.utils;


import javax.swing.JTree;
import javax.swing.tree.TreePath;

/**
 * Helper class that provides JTree functions that are often used.
 */
public final class TreeHelpers
{
	/**
	 * Finds the node at a given mouse cursor position.
	 *
	 * @param tree
	 *            The tree where the node is located.
	 * @param x
	 *            The x coordinate of the mouse position.
	 * @param y
	 *            The y coordinate of the mouse position.
	 *
	 * @return The node at the given cursor position or null if there is no node
	 *         at that position.
	 */
	public static Object getNodeAt(final JTree tree, final int x, final int y)
	{
		final TreePath selPath = tree.getPathForLocation(x, y);

		if (selPath == null)
		{
			return null;
		}

		return selPath.getLastPathComponent();
	}
}
