import sys

from javax.swing import JMenuItem as JMenuItem
from javax.swing import AbstractAction as AbstractAction

from BinNavi.API.helpers import MessageBox as MessageBox
from BinNavi.API.plugins import IMainWindowMenuPlugin as IMainWindowMenuPlugin

class MessageAction(AbstractAction):

	def __init__(self, pi):
		AbstractAction.__init__(self, "Python Sample Plugin")
		
		self.pi = pi

	def actionPerformed(self, e):
		MessageBox.showInformation(self.pi.mainWindow.frame, "Hello from the Python sample plugin :-)")

class SamplePlugin(IMainWindowMenuPlugin):
	def getName(self):
		return "Python Sample Plugin"
	
	def getGuid(self):
		return 545845490
		
	def getDescription(self):
		return "Displays a message box"
		
	def init(self, pi):
		self.pi = pi
		
	def unload(self):
		pass
	
	def extendPluginMenu(self):
		return [ JMenuItem(MessageAction(self.pi)) ]

sample = SamplePlugin()
navi.getPluginRegistry().addPlugin(sample)