require 'java'
include_class "javax.swing.JMenuItem"
include_class "javax.swing.AbstractAction"
include_class "BinNavi.API.helpers.MessageBox"
include_class "BinNavi.API.plugins.IMainWindowMenuPlugin"

class MessageAction < AbstractAction

	def initialize(pi)
		super("Ruby Sample Plugin")
		
		@pi = pi
	end

	def actionPerformed(e)
		MessageBox.showInformation(@pi.mainWindow.frame, "Hello from the Ruby sample plugin :-)")
	end
end

class SamplePlugin
	include IMainWindowMenuPlugin
	
	def getDescription()
		return "Ruby Sample Plugin"
	end
	
	def getGuid()
		return 423794032
	end
	
	def getName()
		return "Displays a message box"
	end
	
	def init(pi)
		@pi = pi
	end
	
	def unload()
	end
	
	def extendPluginMenu()
		return [ JMenuItem.new(MessageAction.new(@pi)) ]
	end
		
end

$navi.getPluginRegistry().addPlugin(SamplePlugin.new())
