set search_path to "BinExport";
--set enable_seqscan = off;	-- uncomment this to force index use if index is available. useful when looking for missing indices
--create language plpgsql; 	-- needs to be executed once before we can create the stored procedures
--vacuum analyze;		-- should be run as part of a periodic maintenance script
--drop function "convertNativeTables"( in integer );

-- Server settings for performance 
-- effective_cache_size = system memory / 2
-- shared_buffers = system memory / 4
-- http://www.revsys.com/writings/postgresql-performance.html
-- http://www.westnet.com/~gsmith/content/postgresql/pg-5minute.htm

create or replace function "convertNativeTables"( in integer )
returns void
returns null on null input 
as $$
declare
      "var_module_id" alias for $1;
      "var_navi_module_id" integer;
      "var_operand_id" integer;
      "var_expression_id" integer;
      "var_node_id" integer;
begin
	"var_operand_id" = ( select coalesce( max( "id" ), 0 ) from "bn_operands" );
	"var_expression_id" = ( select coalesce( max( "id" ), 0 ) from "bn_expression_tree" );
	"var_node_id" = ( select coalesce( max( "id" ), 0 ) from "bn_nodes" );	
	

	insert into "bn_modules"( "name", "md5", "sha1", "description", "file_base", "image_base", "import_time" ) 
	(
		select 
			"name", 
			"md5", 
			"sha1", 
			"comment", 
			"base_address", 
			"base_address", 
			current_timestamp 
		from "modules" 
		where "id" = "var_module_id"
	);


	"var_navi_module_id" = ( select max( "id" ) from "bn_modules" );


	execute 
	'insert into "bn_expression_tree"( "type", "symbol", "immediate", "position", "parent_id" ) 
	(
		select 
			( enum_range( null::"bn_t_expression_tree_type" ))["series"], 
			"symbol", 
			"immediate", 
			"position", 
			"parent_id" + ( select coalesce( max( id ), 0 ) from "bn_expression_tree" ) as "parent_id"
		from "ex_' || "var_module_id" || '_expression_tree"
		inner join generate_series( 1, 7 ) "series"
			 on "series" = "expr_type"
		order by "id"
	);';


	-- @todo: this can be made more efficient with recursive CTEs, see 
	-- http://explainextended.com/2009/11/26/postgresql-selecting-records-holding-group-wise-maximum/
	execute
	'insert into "bn_instructions"( "module_id", "address", "mnemonic", "comment", "data", "native", "architecture" ) 
	(
		select 
			distinct on ( "instructions"."address" )
			' || "var_navi_module_id" || ', 
			"instructions"."address", 
			"instructions"."mnemonic", 
			coalesce( "comments"."comment", '''' ) as "comment",
			"data", 
			true, 
			"modules"."architecture"
		from "ex_' || "var_module_id" || '_instructions" as "instructions"
		left join "ex_' || "var_module_id" || '_address_comments" as "comments"
			 on "comments"."address" = "instructions"."address" 
		inner join "modules"
			 on "modules"."id" = ' || "var_module_id" || '
		where "mnemonic" is not null 
		order by "instructions"."address" 
	);';


	execute
	'insert into "bn_operands"( "instruction", "position" ) 
	(
		select 
			"instructions"."id", 
			"position" 
		from "ex_' || "var_module_id" || '_operand_tuples" as "operands" 
		inner join "bn_instructions" as "instructions" 
			 on "instructions"."address" = "operands"."address"  
			and "instructions"."module_id" = ' || "var_navi_module_id" || '
		order by "operand_id"
	);';


	execute
	'insert into "bn_operand_expressions" 
	(
		select 
			"operand_id" + ' || "var_operand_id" || ',
			"expr_id" + ' || "var_expression_id" || '
		from "ex_' || "var_module_id" || '_operand_expressions"
	);';

	
	execute
	'insert into "bn_expression_substitutions"( "instruction", "operand_id", "expression_id", "replacement" ) 
	(
		select 
			"instructions"."id", 
			"operand_id" + ' || "var_operand_id" || ',
			"expr_id" + ' || "var_expression_id" || ',
			"replacement" 
		from "ex_' || "var_module_id" || '_expression_substitutions" as "substitutions"
		inner join "bn_instructions" as "instructions" 
			 on "instructions"."address" = "substitutions"."address"
			and "instructions"."module_id" = ' || "var_navi_module_id" || '
	);';	


	-- @bug: why do we need the distinct on here? Apparently the exporter exports two different 
	--	 target addresses whenever a structure member is being referenced, i.e.: structure.stringmember
	execute
	'insert into "bn_address_references"( "address", "operand_id", "expression_id", "type", "target" ) 
	(
		select 
			distinct on ( "references"."address", "operand_id", "expression_id", "kind" )
			"instructions"."id", 
			"operand_id" + ' || "var_operand_id" || ', 
			"expression_id" + ' || "var_expression_id" || ', 
			( enum_range( null::"bn_t_address_references_type" ))["series"], 
			"target" 
		from "ex_' || "var_module_id" || '_address_references" as "references"
		inner join "bn_instructions" as "instructions" 
			 on "instructions"."address" = "references"."address" 
			and "instructions"."module_id" = ' || "var_navi_module_id" || '
		inner join generate_series( 1, 9 ) "series"
			 on "series" = "kind" + 1		
		where "operand_id" is not null 
	);';	


	execute
	'insert into "bn_functions" 
	(
		select 
			' || "var_navi_module_id" || ' as "module_id",
			"address", 
			"name", 
			"name" as "original_name",
			( enum_range( null::"bn_t_functions_type" ))["series"], 
			'''' as "description", 
			'''' as "comment", 
			"module_name" as "parent_module_name", 
			null as "parent_module_id", 
			null as "parent_module_function"
		from "ex_' || "var_module_id" || '_functions" 
		inner join generate_series( 1, 5 ) "series"
			 on "series" = "function_type" + 1	
		where "address" <> 0 -- exclude the dummy callgraph function
		order by "address"
	);';


	insert into "bn_views"( "type", "name", "description", "creation_date", "modification_date" ) 
	(
		select 
			'native' as "type", 
			"name", 
			'' as "description",
			current_timestamp as "creation_date", 
			current_timestamp as "modification_date"
		from "bn_functions" 
		where "module_id" = "var_navi_module_id"
	);


	insert into "bn_module_views"
	(
		select 
			"id", 
			"var_navi_module_id" as "module_id"
		from "bn_views"
		order by "id" desc -- important! we want the most recently inserted ids
		limit ( select count(*) from "bn_functions" where "module_id" = "var_navi_module_id" )
	);


	insert into "bn_function_views" 
	(
		select 
			row_number() over ( order by "address" ) 
				+ ( select coalesce( min( "node_id" ), 0 ) from "bn_code_nodes" where "module_id" = "var_navi_module_id" )
				+ ( select coalesce( max( "view_id" ), 0 ) from "bn_function_views" ),
			"var_navi_module_id",
			"address"
		from "bn_functions"
		where "module_id" = "var_navi_module_id"
		order by "address"
	);


	execute
	'insert into "bn_nodes"( "view_id", "parent_id", "type", "x", "y", "color", "selected", "visible" ) 
	(
		select 
			distinct on ( "id", "basicblocks"."address" )
			"view_id", 
			null as "parent_id", 
			''code'' as "type", 
			0 as "x", 
			0 as "y",
			0 as "color", 
			false as "selected", 
			true as "visible" 
		from "ex_' || "var_module_id" || '_basic_blocks" as "basicblocks"
		inner join "ex_' || "var_module_id" || '_functions" as "functions"
			 on "functions"."address" = "basicblocks"."parent_function" 
			and "functions"."function_type" <> 2
		inner join "bn_function_views" as "bnfunctionviews" 
			 on "bnfunctionviews"."function" = "functions"."address" 
			and "bnfunctionviews"."module_id" = ' || "var_navi_module_id" || '
		inner join "bn_functions" as "bnfunctions" 
			 on "bnfunctions"."address" = "bnfunctionviews"."function" 
			and "bnfunctions"."module_id" = ' || "var_navi_module_id" || '
		order by "id"
	);';


	insert into "bn_code_nodes" 
	(
		select 
			"id" as "node_id", 
			"var_navi_module_id" as "module_id",
			"function" as "parent_function", 
			'' as "comment"
		from "bn_nodes" as "nodes"
		inner join "bn_function_views" as "views"
			 on "views"."view_id" = "nodes"."view_id"
		where "type" = 'code' 
			and "id" >= "var_node_id"
	);


	-- ~10min for 3.500.000 rows
	execute
	'insert into "bn_codenode_instructions" 
	select 
		"bnnodes"."id", 
		"sequence", 
		"bninstructions"."id", 
		'''' as "comment"
	from "ex_' || "var_module_id" || '_instructions" as "instructions" 
	inner join "bn_instructions" as "bninstructions" 
		 on "bninstructions"."module_id" = ' || "var_navi_module_id" || '
		and "bninstructions"."address" = "instructions"."address" 
	inner join "bn_nodes" as "bnnodes" 
		 on "bnnodes"."id" = "basic_block_id" - 1 + ( select min( "node_id" ) from "bn_code_nodes" where "module_id" = ' || "var_navi_module_id" || ' )
	inner join "bn_views" as "bnviews"
		 on "bnviews"."id" = "bnnodes"."view_id" 
	inner join "bn_function_views" as "bnfunctionviews"
		 on "bnfunctionviews"."view_id" = "bnviews"."id" 
	where "instructions"."mnemonic" is not null 
	order by "bninstructions"."id";';	


	drop table if exists "address_to_node";
	create temporary table "address_to_node" as 
	select 
		"nodes"."parent_function" as "parent_function",
		"nodes"."node_id" as "node_id",
		"instructions"."address" as "address"
	from "bn_code_nodes" as "nodes"
	inner join "bn_codenode_instructions" as "nodeinstructions"
		 on "nodeinstructions"."node_id" = "nodes"."node_id"
		and "nodeinstructions"."position" = 0
	inner join "bn_instructions" as "instructions"
		 on "instructions"."module_id" = "var_navi_module_id"
		and "instructions"."id" = "nodeinstructions"."instruction"
	where "nodes"."module_id" = "var_navi_module_id";

	create index "address_to_node_primary" on "address_to_node" ( "parent_function", "address" );


	execute
	'insert into "bn_edges"
	select 
		"flowgraph"."id" + ( select coalesce( max( "id" ), 0 ) from "bn_edges" ),
		"sourceNode"."node_id" as "source_node", 
		"targetNode"."node_id" as "target_node",
		'''' as "comment",
		0.0 as "x1",
		0.0 as "y1",
		0.0 as "x2",
		0.0 as "y2",
		( enum_range( null::"bn_t_edges_type" ))["series"] as "kind",
		0 as "color",
		true as "visible",
		false as "selected"
	from "ex_' || "var_module_id" || '_control_flow_graph" as "flowgraph"
	inner join "ex_' || "var_module_id" || '_basic_blocks" as "sourcebasicblock"
		 on "sourcebasicblock"."parent_function" = "flowgraph"."parent_function"
		and "sourcebasicblock"."id" = "flowgraph"."src"
	inner join "ex_' || "var_module_id" || '_basic_blocks" as "targetbasicblock"
		 on "targetbasicblock"."parent_function" = "flowgraph"."parent_function"
		and "targetbasicblock"."id" = "flowgraph"."dst"
	inner join "address_to_node" as "sourceNode"
		 on "sourceNode"."parent_function" = "sourcebasicblock"."parent_function"
		and "sourceNode"."address" = "sourcebasicblock"."address"
	inner join "address_to_node" as "targetNode"
		 on "targetNode"."parent_function" = "sourcebasicblock"."parent_function"
		and "targetNode"."address" = "sourcebasicblock"."address"
	inner join generate_series( 1, 12 ) "series"
		 on "series" = "kind" + 1;';


/*
-- @todo: implement
select bn_nodes.id from bn_nodes join bn_module_views on bn_nodes.view_id = bn_module_views.view_id left join bn_edges on bn_nodes.id = bn_edges.target_node_id where bn_module_views.module_id = 1 and target_node_id is null and bn_nodes.type = 'code'
update bn_nodes set bn_nodes.bordercolor = -16736256 where bn_nodes.id in (1, 6, 10, 11, 34, 37, 50, 56, 57, 65, 73, 85, 92, 103, 116, 137, 151, 160, 198, 219, 237, 246, 342, 348, 351, 443, 444, 445, 451, 456, 461, 468, 475, 488, 498, 511, 516, 533, 564, 565, 566, 567, 609, 614, 627, 633, 638, 644, 654, 658, 699, 779, 794, 805, 832, 853, 860, 861, 876, 877, 897, 947, 958, 970, 982, 995, 1057, 1066, 1082, 1095, 1111, 1112, 1118, 1123, 1124, 1130, 1141, 1142, 1143, 1144, 1171, 1172, 1173, 1174, 1175, 1176, 1177, 1178)
select bn_nodes.id from bn_nodes join bn_module_views on bn_nodes.view_id = bn_module_views.view_id left join bn_edges on bn_nodes.id = bn_edges.source_node_id where bn_module_views.module_id = 1 and target_node_id is null and bn_nodes.type = 'code'
update bn_nodes set bn_nodes.bordercolor = -6291456 where bn_nodes.id in (5, 9, 33, 36, 49, 55, 64, 72, 84, 91, 102, 115, 136, 150, 159, 197, 217, 236, 245, 341, 347, 350, 368, 450, 455, 460, 467, 473, 487, 497, 509, 515, 532, 563, 594, 613, 626, 632, 635, 637, 643, 653, 657, 695, 778, 793, 804, 831, 852, 859, 875, 896, 946, 949, 957, 969, 981, 994, 1056, 1065, 1081, 1094, 1110, 1117, 1120, 1122, 1129, 1140, 1169, 1170)
update bn_nodes set bn_nodes.bordercolor = -6250496 where bn_nodes.id in (10,56,443,444,564,565,566,860,876,1111,1123,1141,1142,1143,1171,1172,1173,1174,1175,1176,1177,1178)
*/	


	insert into "bn_views"( "type", "name", "description", "creation_date", "modification_date" ) 
		values ( 'native', 'Native Callgraph', '', current_timestamp, current_timestamp );


	insert into "bn_module_views"( "view_id", "module_id" ) 
	(
		select 
			max( "id" ) as "view_id",
			"var_navi_module_id" as "module_id"
		from "bn_views"
	);


	insert into "bn_nodes"( "view_id", "parent_id", "type", "x", "y", "color", "selected", "visible" ) 
	(
		select 
			( select max( "id" ) from "bn_views" ) as "view_id", 
			null as "parent_id", 
			'function' as "type", 
			0 as "x", 
			0 as "y", 
			0 as "color", 
			false as "selected", 
			true as "visible" 
		from "bn_functions" 
		where "module_id" = "var_navi_module_id"
		order by "address"
	);


	insert into "bn_function_nodes"( "node_id", "module_id", "function", "comment" ) 
	with "functions" as 
	(
		select 
			row_number() over ( order by "address" ) as "id",
			"address"
		from "bn_functions"
		where "module_id" = "var_navi_module_id"
	)
	select 	
		"nodes"."id",
		"var_navi_module_id" as "module_id",
		"address",
		'' as "comment"
	from "functions"
	inner join "bn_nodes" as "nodes"
		 on "nodes"."view_id" = ( select max( "id" ) from "bn_views" )
		and "nodes"."id" = "functions"."id" - 1 
			+ ( select min( "id" ) from "bn_nodes" where "view_id" 
				= ( select max( "id" ) from "bn_views" ));


	execute
	'insert into "bn_edges"( "id", "source_node_id", "target_node_id", "comment", "x1", "y1", "x2", "y2", "type", "color", "selected", "visible" ) 
	(
		select 
			"callgraph"."id" + ( select coalesce( max( "id" ), 0 ) from "bn_edges" ) as "id",
			"sourcenode"."node_id",
			"targetnode"."node_id", 
			'''' as "comment", 
			0 as "x1", 
			0 as "y1", 
			0 as "x2", 
			0 as "y2", 
			''unconditional'' as "type", 
			0 as "color", 
			false as "selected", 
			true as "visible" 
		from "ex_' || "var_module_id" || '_callgraph" as "callgraph"
		inner join "bn_function_nodes" as "sourcenode"
			 on "sourcenode"."function" = "src"
			and "sourcenode"."module_id" = ' || "var_navi_module_id" || '
		inner join "bn_function_nodes" as "targetnode"
			 on "targetnode"."function" = "dst"
			and "targetnode"."module_id" = ' || "var_navi_module_id" || '
	);';


	update "bn_modules" set "initialization_state" = 2147483647 where "id" = "var_navi_module_id";
end;
$$ language 'plpgsql' volatile;

-- ~25 min for ex_14
--select "convertNativeTables"( 14 );

/*
select * from ex_4_callgraph
select * from bn_modules
select * from bn_expression_tree
select * from bn_instructions
select * from bn_operands
select * from bn_operand_expressions
select * from bn_expression_substitutions
select * from bn_address_references
select * from bn_views
select * from bn_module_views
select * from bn_function_views
select * from bn_code_nodes
select * from bn_codenode_instructions
select * from bn_edges
select * from bn_nodes
select * from bn_function_nodes
select * from bn_functions
*/


