//  IDA to SoftIce and NMTrans common definitions
//
//  Author: Mostek
//   mail:  mostekaccess@mailcity.com
#ifndef _NM32
#define _NM32


//---------------------------------------------------------------------------
//Uncomment if you want:

#define WINDOWS2000		//uncomment this line to compile for WIndows2000
//#define IDA55UP			//uncomment this line to compile for IDA55 and up


//---------------------------------------------------------------------------
//All needed includes
#ifndef WINDOWS2000
#define WINVER			0x0400	//for Windows2000 WINVER must be >=0x0500 (this is Default in freeCompiler)
#define _WIN32_WINNT	0x0400	//
#endif

#include <windows.h>

#define BYTES_SOURCE	//for bytes.hpp

#include <IDA.HPP>
#include <BYTES.HPP>
#include <LOADER.HPP>
#include <KERNWIN.HPP>
#include <FUNCS.HPP>
#include <STRUCT.HPP>
#include <AREA.HPP>
#include <FRAME.HPP>
#include <NAME.HPP>
#include <DISKIO.HPP>
#include <TYPEINF.HPP>

#include "nm32.h"
 
//#include <AUTO.HPP>
//#include <IDP.HPP>
//#include <NETNODE.HPP>
//#include <LINES.HPP>
//#include <AREG.HPP>
//#include <SEGMENT.HPP>

//#include <err.h>
//#include <exehdr.h>
//#include <FPRO.H>
//#include <HELP.H>
//#include <IEEE.H>
//#include <PRO.H>
//#include <PRODIR.H>
//#include <DEMANGLE.HPP>
//#include <DISKIO.HPP>
//#include <ENTRY.HPP>
//#include <ENUM.HPP>
//#include <EXPR.HPP>
//#include <FIXUP.HPP>
//#include <INTS.HPP>
//#include <ITYPE.HPP>
//#include <LLONG.HPP>
//#include <MICRO.HPP>
//#include <NALT.HPP>
//#include <OFFSET.HPP>
//#include <QUEUE.HPP>
//#include <SRAREA.HPP>
//#include <UA.HPP>
//#include <VA.HPP>
//#include <VM.HPP>
//#include <XREF.HPP>


//*********************************************************************************************************************
//Equs

//IDA to SoftIce
#define SUCCESS_	1
#define FAILED_		0

//Primitive types (to see all look into 'Primitive Type Listing.txt'
#define TP_NOTYPE       0x0000    //Uncharacterized type (no type)
#define TP_VOID         0x0003    //Void
#define TP_CHAR         0x0010    //8-bit signed
#define TP_UCHAR        0x0020    //8-bit unsigned
#define TP_SHORT        0x0011    //16-bit signed
#define TP_USHORT       0x0021    //16-bit unsigned
#define TP_LONG         0x0012    //32-bit signed
#define TP_ULONG        0x0022    //32-bit unsigned
#define TP_QUAD         0x0013    //64-bit signed
#define TP_UQUAD        0x0023    //64-bit unsigned
#define TP_REAL32       0x0040    //32-bit real
#define TP_REAL64       0x0041    //64-bit real
#define TP_REAL80       0x0042    //80-bit real

//*********************************************************************************************************************
//Structures

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//Created sections
struct SECTIONS_S		//fixed memory
{
	unsigned long*	nm32;
	unsigned long*	sttb;
	unsigned long*	nmtp;
	unsigned long*	tytb;
	unsigned long*	hsht;
	unsigned long*	symd;
	unsigned long*	fpod;
	unsigned long*	srcp;
	unsigned long*	gtyp;
};
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//STTB
struct	STTB_S		//moveable memory
{
	HLOCAL			hStrings;			//memory handle
	HLOCAL			hOffsets;

	char*			strings;			//Pointer to buffer with zero ended strings.
	unsigned long*	offsets;			//Pointer to buffer with offsets to strings in string buffer.
	char*			stringsCurrent;		//Pointer to 1st free byte in strings buffer.
	unsigned long*	offsetsCurrent;		//Pointer to 1st free dword in offsets buffer.
	unsigned long	freeStrings;		//Size of free bytes in string buffer.
	unsigned long	freeOffsets;		//Size of free dwords in offsets buffer.
	unsigned long	sizeStrings;		//Current size in bytes of whole strings buffer.
	unsigned long	sizeOffsets;		//Current size in dwords of whole offsets buffer.
	unsigned long	cStrings;			//Number of strings/offsets in string/offsets buffer.
};
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//NMTP
struct NMTP_S		//moveable memory
{
	HLOCAL				hTypesData;
	HLOCAL				hTypesOffsets;

	unsigned char*		typesData;				//bite size for pointers
	unsigned long*		typesOffsets;
	unsigned char*		typesDataCurrent;
	unsigned long*		typesOffsetsCurrent;
	unsigned long		freeTypesData;
	unsigned long		freeTypesOffsets;
	unsigned long		sizeTypesData;
	unsigned long		sizeTypesOffsets;
	unsigned long		cTypesData;
};
//typesData:
//|---------------------------|
//|local label                | (type:0x1000) |
//|---------------------------|               |
//|global label               | (type:0x1001) |  this three are predefined in i2s plugIn
//|---------------------------|               |
//|local procedure(arglist=0) | (type:0x1002) |
//|---------------------------|
//Local procedure(near pascal): pushed data is defined as local variable => arglist=0.

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//TYTB
struct TYTB_S		//moveable memory
{
	HLOCAL				hTypeTables;

	TYPETABLE*			typeTables;
	TYPETABLE*			typeTablesCurrent;
	unsigned long		freeTypeTables;
	unsigned long		sizeTypeTables;
	unsigned long		cTypeTables;
};
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct HSHT_S		//moveable memory
{
	HLOCAL				hHashTables;

	HSHT_TYPETABLE*		hashTables;
	HSHT_TYPETABLE*		hashTablesCurrent;
	unsigned long		freeHashTables;
	unsigned long		sizeHashTables;
	unsigned long		cHashTables;

	unsigned long		hashOffsets[0x25];
};
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//SYMD  (there will always be just one source file)
struct SEGMENT_DATA		//moveable memory
{
	SEGMENT_DATA*		pNext;	//pointer to next segment

	unsigned long		nSeg;
	unsigned long		iNameSegment;
	unsigned long		physSize;
//-------------------------------
	HLOCAL				hProcDefinitions;

	SEGDATA_PROCEDURE*	procDefinitions;
	SEGDATA_PROCEDURE*	procDefinitionsCurrent;
	unsigned long		freeProcDefinitions;
	unsigned long		sizeProcDefinitions;	//size of the buffer
	unsigned long		cProcDefinitions;
//-------------------------------
	HLOCAL				hLocalVariables;

	SEGDATA_VLPTABLE*	localVariables;
	SEGDATA_VLPTABLE*	localVariablesCurrent;
	unsigned long		freeLocalVariables;
	unsigned long		sizeLocalVariables;
	unsigned long		cLocalVariables;
	unsigned long		offsetLVarCurrent;	//current offset in localVariables buffer
//-------------------------------
	HLOCAL					hSourceLines;

	SEGDATA_SOURCELINES*	sourceLines;
	SEGDATA_SOURCELINES*	sourceLinesCurrent;
	unsigned long			freeSourceLines;
	unsigned long			sizeSourceLines;
	unsigned long			cSourceLines;
//-------------------------------
	HLOCAL				hVLP;
	HLOCAL				hVLPOffsets;

	SEGDATA_VLPTABLE*	VLP;
	unsigned long*		VLPOffsets;
	SEGDATA_VLPTABLE*	VLPCurrent;
	unsigned long*		VLPOffsetsCurrent;
	unsigned long		freeVLP;
	unsigned long		freeVLPOffsets;
	unsigned long		sizeVLP;
	unsigned long		sizeVLPOffsets;
	unsigned long		cVLP;
//-------------------------------
	SEGDATA_SOURCESECTION	sourceSection;	//every segment will have only one source code(1 source section and
											//one source file) so that we can see whole segment in SoftIce
	SEGDATA_SOURCEFILE	sourceFile;
//NOTICE!
//Currently only one code segment is supported.
};
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
struct SYMD_S	//fixed memory
{
	SEGMENT_DATA*		segments;	//pointer to 1st segment(=>2.seg(=>3.seg(...)))
	SEGMENT_DATA*		segmentCurrent;

	unsigned long		cSegments;
};

//*********************************************************************************************************************
//Global variables
extern STTB_S			sttb;
extern NMTP_S			nmtp;
extern TYTB_S			tytb;
extern HSHT_S			hsht;
extern SYMD_S			symd;
extern SECTIONS_S		sections;

extern unsigned long	lineNumberCurrent;
extern unsigned long	offInSFDefCurrent;
extern unsigned long	cSourceFiles;
extern unsigned long	minEA;		//this one must be set at start of current segment
									//(If you're in code segment => minEA=start of code segment;
									// if you're in data segment => minEA=start of data segment)
extern char*			copyright;

extern unsigned long	plugInFlags;	//bit flags
#define SOFTICELOADED			0x0001
#define SOFTICETESTEDALREADY	0x0002
#define PLUGINRUNNING			0x0004
#define PLUGINNOTRUNNING		0xFFFFFFFB
#define USERCANCELLED			0x0008
#define USERNOTCANCELLED		0xFFFFFFF7


//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
//Global functions
extern int				InitializeMemory(void);			//no parameters => initialization of the memory
extern int				InitializeMemory(int, HLOCAL, void**, void**, unsigned long*, unsigned long*);
extern SEGMENT_DATA*	InitializeMemory_SYMD_S(void);	//get pointer to new SEGMENT_DATA
extern int				InitializeMemory_SYMD(void);	//check for old SEGMENT_DATA-s and set new
														//this procedure should be called when you want to set
														//a new segment
extern int				FreeMemory(void);
extern unsigned long	CopyDWORDMemory(unsigned long*, unsigned long*, unsigned long);
extern void				ResetGlobalVariables(void);
//Allocate Memory
#define ALLOCATEBIG		0x10000			//allocate 64kb
#define ALLOCATESMALL	0x400			//0x1000=0x400*4 (allocate 400 DWORDs)

#define REALLOCATEBIG	0
#define REALLOCATESMALL	1

#define MEMORY_STTB				0
#define MEMORY_NMTP				1
#define MEMORY_TYTB				2
#define MEMORY_HSHT				3
#define MEMORY_SYMD_PROCEDURE	4
#define MEMORY_SYMD_LOCAL		5
#define MEMORY_SYMD_VLP			6
#define MEMORY_SYMD_SOURCELINES	7
#define MEMORY_SYMD_SOURCEFILES 8

//*********************************************************************************************************************
//IDA to SoftIce class
class SetSoftIce{
	private:
		int CheckMemory(unsigned long, unsigned long);
		int CheckMemory(unsigned long, unsigned long, unsigned long);

//nm32 strings
		unsigned long SetStringTable(char*);

//nm32 types
		unsigned long currentIndex;

		unsigned long NMTP_UpdateNMTPStruct(unsigned long);

		unsigned long NMTP_SetMember(member_t* );
		unsigned long NMTP_SetDerived(struc_t*);
		unsigned long NMTP_SetArglist(struc_t*, unsigned long, unsigned long);

		unsigned long NMTP_SetArray(unsigned long, unsigned long);
		unsigned long NMTP_SetProcedure(func_t*);
		unsigned long NMTP_SetStructure(struc_t*);

//nm32 symbols
		inline void SYMD_SetVLP_Procedure(func_t*);
		inline void SYMD_SetProcedureStruct(func_t*, unsigned long);
		int SYMD_SetProcedure(func_t*);
		int	SYMD_SetDataVariables(segment_t*);

//nm32 TYTB, HSHT
		inline unsigned long GetHashNumber(char*);
		inline unsigned long SetHashOffset(unsigned long);
		int Set_TYTB_HSHT(unsigned long, char*, unsigned long);
		int Set_TYTB_HSHT(unsigned long, char*);

//create sections
		unsigned long* SetSection_NMTP(void);
		unsigned long* SetSection_STTB(void);
		unsigned long* SetSection_TYTB(void);
		unsigned long* SetSection_HSHT(void);
		unsigned long* SetSection_SYMD(void);
		unsigned long* SetSection_NM32(unsigned long);

	public:
		SetSoftIce()		//constructor
		{
			currentIndex=0x1003;	//1000=localLabel, 1001=globalLabel, 1002=localProcedure
		}

		void Set_SoftIce(void); //"constructor" <-it's just a second part of constructor, it MUST be called
								//after InitializeMemory() was called
								//because constructor can't return value I have to do it like this
//nm32 types
	//Get type
		unsigned long GetType_flag(flags_t);		//supports (byte, word, dword, qword, float, double, packreal) (intended for arguments)
		unsigned long GetType_ea(ea_t);				//supports all types (intended for DATA segment)
		unsigned long GetType_member(member_t*);	//supports all types (intended for argument/lVariables (procedure frame))

//other
	//Get Count functions
		unsigned long GetProcedureArgCount(func_t*, unsigned long*);
		unsigned long GetProcedureLVarCount(func_t*);
		unsigned long GetStructureMemberCount(struc_t*);
		SEGDATA_VLPTABLE* SetLocalStructMembers(struc_t*, char*, unsigned long, SEGDATA_VLPTABLE*);


//Create_Load functions
		unsigned long* GetNMSFile(unsigned long);
		int LoadNMSFile(unsigned long*);
};

//*********************************************************************************************************************
//---------------------------------------------------------------------------------------------------------------------
//NMTrans

struct MODULEINFO
{
	char*			pModuleName;
	unsigned long*	pMappedFile;
	unsigned long	fileSize;
	char*			pSourceCode;
	unsigned long	sourceLength;
};
// pModuleName - Pointer to original module name. (from exe,..)
// pMappedFile - Pointer to mapped view of NMS file.
// fileSize - Size of NMS file.
// pSourceCode - Pointer to source files buffer.
//               NULL if source is in NMS file OR there is no source.
// sourceLength - Length of source files buffer.
//
//sourceCodeBuffer = All source files one after onother as they would be in NMS file.
//



#endif

