/*------------------------------------------------------------*/
/* filename -       tlistbox.cpp                              */
/*                                                            */
/* function(s)                                                */
/*                  TListBox member functions                 */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_TListBox
#define Uses_TEvent
#define Uses_TCollection
#define Uses_opstream
#define Uses_ipstream
#include <tv.h>

struct TListBoxRec
{
    TCollection *items;
    int selection;
};

TListBox::TListBox( const TRect& bounds,
                    ushort aNumCols,
                    TScrollBar *aScrollBar ) :
    TListViewer(bounds, aNumCols, 0, aScrollBar),
    items( 0 )
{
    setRange(0);
}

TListBox::~TListBox()
{
}

size_t TListBox::dataSize()
{
    return sizeof(TListBoxRec);
}

void TListBox::getData( void * rec, size_t recsize )
{
  if ( ssize_t(recsize) >= (ssize_t)sizeof(TListBoxRec) )
  {
    TListBoxRec *p = (TListBoxRec *)rec;
    p->items = items;
    p->selection = focused;
  }
}

void TListBox::getText( char *dest, int item, size_t destsize )
{
  if ( ssize_t(destsize) > 0 )
  {
    if (items != 0 )
      qstrncpy( dest, (const char *)(items->at(item)), destsize );
    else
      *dest = EOS;
  }
}

void TListBox::newList( TCollection *aList )
{
    destroy( items );
    items = aList;
    if( aList != 0 )
        setRange( aList->getCount() );
    else
        setRange(0);
    if( range > 0 )
        focusItem(0);
    drawView();
}

void TListBox::setData( void *rec )
{
    TListBoxRec *p = (TListBoxRec *)rec;
    newList(p->items);
    focusItem(p->selection);
    drawView();
}

#ifndef NO_TV_STREAMS
void TListBox::write( opstream& os )
{
    TListViewer::write( os );
    os << items;
}

void *TListBox::read( ipstream& is )
{
    TListViewer::read( is );
    is >> items;
    return this;
}

TStreamable *TListBox::build()
{
    return new TListBox( streamableInit );
}

TListBox::TListBox( StreamableInit ) : TListViewer( streamableInit )
{
}
#endif  // ifndef NO_TV_STREAMS


