#
#	Common part of make files for IDA.
#

# .AUTODEPEND	- don't use it because only BCC knows about it,
#		  Watcom doesn't.

#	All makesfiles are prepared to be used by BCC MAKE.EXE
#	I use BCC and WATCOM compilers

#--------------------------- Compiler Directories --------------------------
# Borland C++ for OS/2 v1.5
# If environment variable is not set, set default value:
!ifndef BC2
BC2=d:\bcos2\           # BCOS/2 1.5 directory
!endif

# Borland C++ for DOS v3.1
# If environment variable is not set, set default value:
!ifndef BC31
BC31=f:\bcc\            # BCC 3.1 directory
!endif

# Borland C++ Builder v4.x
# If environment variable is not set, set default value:
!ifndef BC501
BC501=d:\progra~1\borland\cbuilder4\  # BCC directory
!endif
!ifndef BC5_COM
BC5_COM=BC501
TV=ui\txt\tv\		# TurboVision subdirectory
!else
TV=tvision\		# TurboVision subdirectory
!endif

.phony: all All goal Goal total Total

######################### set debug switches
#DEBUG=1
!ifdef DEBUG
!ifdef __WATCOMC__			# Watcom
#CCDEBUG=-d1
!else					# assume Borland
CCDEBUG=-v
CCNOOPT=-O-
!endif
!endif

# include and help directories are common for all platforms and compilers:
I=$(IDA)include\\
H=$(IDA)help\           # help directory
HS=.hls			#	help source
HH=.hhp			#	help headers

#############################################################################
!if $d(OS2_SHELL)	# running under OS/2?
RS	=$(IDA)bin\os2\ 				# host utilities directory
!elif $d(__NT__)	# compiling for Win'95?
RS	=$(IDA)bin\w32\ 				# host utilities directory
!else			# otherwise - MS DOS
RS	=$(IDA)bin\w32\					# host utilities directory
!endif

#############################################################################
!if $d(__WATCOMC__) && $d(__MSDOS__) && !$d(__NT__)	# Watcom DOS 32
__IDA_MSDOS__=1
__DOS32__=1
IMPLIB	=implib						# implib executable name
ASM	=wasm						# assembler
CC	=wpp386						# C++ compiler
CFLAGS	=@$(IDA)d32wat.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/d__WATCOM__ /3r /mf /e $(_AFLAGS)		# default assembler flags
OUTSW	=/fe=						# outfile name switch for one-line linker
OUTDLL	=/bd						# output is DLL switch
LINKER	=$(RS)ld $(_LDFLAGS)				# indirect file linker
CCL	=$(RS)ld _lwcl386 -l=dos4g /\"option stack=96k\" $(_CFLAGS) $(CCDEBUG) $(_LDFLAGS) # one-line linker
LINKSYS	=dos4g						# target link system
LINKSYS_EXE=dos4g					# target link system for executable
C_STARTUP=						# indirect linker: C startup file
C_LIB	=						# indirect linker: default C library
L	=$(IDA)libwat.d32\				# libraries directory
TL	=$(IDA)$(TV)libwat.d32\		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
F	=wat.d32\					# object files directory
B	=x.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.mp3						# map file extension
T	=.ad3						# library flag file extension
IDP	=.d32						# IDP extension
LDR     =.ldx                                           # LDR extension
PLUGIN  =.pld                                           # PLUGIN extension
DLLEXT  =$(B)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.apw						# API definition file extension
DEF	=.dfw						# DEF file extension
IDPSTUB	=$(L)inirt386$(O)				# STUB file for IDPs
LDRSTUB =$(L)inirt386$(O)                               # STUB file for LDRs
IDPSLIB =clib3r						# system libraries for IDPs
AR	=$(RS)ar$(BS) _e$(T) "_lwlib -b -s -t" ruv	# librarian
APISW   =-sdos32
#############################################################################
!elif $d(__WATCOMC__) && $d(__NT__)			# Watcom Windows NT
IMPLIB	=implib						# implib executable name
ASM	=wasm						# assembler
CC	=wpp386						# C++ compiler
CFLAGS	=@$(IDA)w32wat.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/d__WATCOM__ /3r /mf /e $(_AFLAGS)		# default assembler flags
OUTSW	=/fe=						# outfile name switch for one-line linker
OUTDLL	=/bd						# output is DLL switch
LINKER	=$(RS)ld $(_LDFLAGS)				# indirect file linker
CCL	=$(RS)ld _lwcl386 -l=nt $(_CFLAGS) $(CCDEBUG) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=nt  					# target link system for executable
LINKSYS	=$(LINKSYS_EXE) dll initinstance terminstance	# target link system
C_STARTUP=						# indirect linker: C startup file
C_LIB	=						# indirect linker: default C library
L	=$(IDA)libwat.w32\				# libraries directory
TL	=$(IDA)$(TV)libwat.w32\		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
!if  !$d(IM)
R	=$(R)w32\					# results directory
!endif
F	=wat.w32\					# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.mpn						# map file extension
T	=.awn						# library flag file extension
IDP	=.w32						# IDP extension
LDR     =.ldw                                           # LDR extension
PLUGIN  =.plw                                           # PLUGIN extension
DLLEXT  =.dll
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.apw						# API definition file extension
DEF	=.dfw						# DEF file extension
IDPSTUB	=						# STUB file for IDPs
LDRSTUB =                                               # STUB file for LDRs
IDPSLIB =clib3r						# system libraries for IDPs
AR	=$(RS)ar$(BS) _e$(T) "_lwlib -b -s -t" ruv	# librarian
#############################################################################
!elif $d(__WATCOMC__)					# Watcom OS/2 programs
__IDA_OS2__=1
__OS2WAT__=1
IMPLIB	=implib						# implib executable name
ASM	=wasm						# assembler
CC	=wpp386						# C++ compiler
CFLAGS	=@$(IDA)os2wat.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/d__WATCOM__ /3r /mf /e $(_AFLAGS)		# default assembler flags
OUTSW	=/fe=						# outfile name switch for one-line linker
OUTDLL	=/bd						# output is DLL switch
LINKER	=$(RS)ld $(_LDFLAGS)				# indirect file linker
CCL	=$(RS)ld _lwcl386 -l=os2v2 $(_CFLAGS) $(CCDEBUG) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=os2v2  					# target link system for executable
LINKSYS	=$(LINKSYS_EXE) dll initinstance terminstance	# target link system
C_STARTUP=						# indirect linker: C startup file
C_LIB	=						# indirect linker: default C library
L	=$(IDA)libwat.os2\				# libraries directory
TL	=$(IDA)$(TV)libwat.os2\		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
!if  !$d(IM)
R	=$(R)os2\					# results directory
!endif
F	=wat.os2\					# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.mpw						# map file extension
T	=.aw2						# library flag file extension
IDP	=.dll						# IDP extension
LDR     =.ldo                                           # LDR extension
PLUGIN  =.pl2                                           # PLUGIN extension
DLLEXT  =.dll
LINKOPTS_EXE=/Gm /s
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.apw						# API definition file extension
DEF	=.dfw						# DEF file extension
IDPSTUB	=						# STUB file for IDPs
LDRSTUB =                                               # STUB file for LDRs
IDPSLIB =clib3r						# system libraries for IDPs
AR	=$(RS)ar$(BS) _e$(T) "_lwlib -b -s -t" ruv	# librarian
APISW   =-sos2
#############################################################################
!elif $d(__NT__)					# Borland C++ for NT (WIN32)
IMPLIB	=$(BC501)bin\implib				# implib executable name
ASM     =$(BC5_COM)bin\tasm32                           # assembler
CC	=$(BC501)bin\bcc32				# C++ compiler
CFLAGS	=+$(IDA)w32bor.cfg $(_CFLAGS) $(CCDEBUG) $(CCNOOPT) # default compiler flags
AFLAGS	=/D__FLAT__ /t/ml/m5$(_AFLAGS)			# default assembler flags
OUTSW	=-n -e   					# outfile name switch for one-line linker
OUTDLL	=/Tpd						# output is DLL switch
!ifdef BASE
NT_BSW  =-b=$(BASE)
!endif
LDFLAGS =$(NT_BSW) -Gn $(_LDFLAGS)
LINKER	=$(BC501)bin\ilink32 $(LDFLAGS) $(CCDEBUG)      # indirect file linker
CCL	=$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=c0x32                                         # indirect linker: C startup file
C_IMP   =import32                                       # import library
#C_LIB   =$(C_IMP) $(L)noeh32 cw32                      # indirect linker: default C library
C_LIB   =$(C_IMP) cw32mt                                # indirect linker: default C library
OVRON	=						# 16bit: following files overlayed
OVROFF	=						# 16bit: following files not overlayed
ORDINALS= #-o                                           # import functions by ordinals
L	=$(IDA)libbor.w32\				# libraries directory
TL	=$(IDA)$(TV)libbor.w32\       			# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
!if  !$d(IM)
R	=$(R)w32\					# results directory
!endif
F	=bor.w32\					# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.mpb						# map file extension
T	=.arb						# library flag file extension
IDP	=.w32						# IDP extension
LDR     =.ldw                                           # LDR extension
PLUGIN  =.plw                                           # PLUGIN extension
DLLEXT  =.wll
# -c case sensitive
# -C clear state before linking
# -s detailed map of segments
# -m detailed map of publics
# -r verbose
LINKOPTS_EXE=-m -s -c -C -r $(ORDINALS) $(CCDEBUG)
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.api						# API definition file extension
DEF	=.df2						# DEF file extension
!if  !$d(NORTL)
IDPSTUB =c0d32                                          # STUB file for IDPs
LDRSTUB =c0d32                                          # STUB file for LDRs
IDPSLIB =$(C_LIB)					# system libraries for IDPs
!else
IDPSTUB =$(L)modstart                                   # STUB file for IDPs
LDRSTUB =$(L)modstart                                   # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR	=$(RS)ar$(BS) _a _e$(T) "_ltlib /C/E/P64" ruv   # librarian
APISW   =-swin -i$(R)ida.imp -n
#############################################################################
!elif $d(__MSDOS__)					# Borland C++ DOS 16
__IDA_MSDOS__=1
__DOS16__=1
IMPLIB	=$(BC31)bin\implib				# implib executable name
ASM	=$(BC31)bin\tasm				# assembler
!ifdef LDR_TRANSLATION
CC	=$(BC501)bin\bcc				# C++ compiler
!else
CC	=$(BC31)bin\bcc				        # C++ compiler
!endif
CFLAGS	=+$(IDA)dosbor.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/t/ml/z/m5$(_AFLAGS)				# default assembler flags
OUTSW	=-e						# outfile name switch for one-line linker
OUTDLL	=/Twd						# output is DLL switch
LINKER	=$(BC31)bin\tlink /m $(_LDFLAGS)		# indirect file linker
CCL	=$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=$(BC31)lib\c0l				# indirect linker: C startup file
C_LIB	=$(BC31)lib\cl					# indirect linker: default C library
OVRON	=-Yo						# 16bit: following files overlayed
OVROFF	=-Yo-						# 16bit: following files not overlayed
L	=$(IDA)lib\					# libraries directory
TL	=$(IDA)$(TV)lib\       		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
F	=						# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.map						# map file extension
T	=.ar						# library flag file extension
IDP	=.idp						# IDP extension
LDR     =.ldd                                           # LDR extension
PLUGIN  =.pl1                                           # PLUGIN extension
DLLEXT  =$(B)
LINKOPTS_EXE=/ye+/yx+/c
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.api						# API definition file extension
DEF	=.def						# DEF file extension
IDPSTUB	=$(L)idpstub$(O)				# STUB file for IDPs
LDRSTUB =$(L)idpstub$(O) $(L)dlldata$(O)                # STUB file for LDRs
IDPSLIB =						# system libraries for IDPs
AR	=$(RS)ar$(BS) _a _e$(T) "_l$(BC31)bin\tlib /C/0/E" ruv	# librarian
APISW   =-sdos16
#############################################################################
!elif $d(__OS2__)					# Borland C++ OS/2
__IDA_OS2__=1
IMPLIB	=$(BC2)bin\implib				# implib executable name
ASM	=$(BC2)bin\tasm				        # assembler
CC	=$(BC2)bin\bcc					# C++ compiler
CFLAGS	=+$(IDA)os2bor.cfg $(_CFLAGS) $(CCDEBUG)        # default compiler flags
AFLAGS	=/D__FLAT__ /t/ml/zi/m5$(_AFLAGS)		# default assembler flags
OUTSW	=-n -e						# outfile name switch for one-line linker
OUTDLL	=/Tod						# output is DLL switch
LINKER	=$(BC2)bin\tlink /m $(_LDFLAGS)		        # indirect file linker
CCL	=$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=$(BC2)lib\c02				        # indirect linker: C startup file
C_LIB	=c2mt os2					# indirect linker: default C library
OVRON	=						# 16bit: following files overlayed
OVROFF	=						# 16bit: following files not overlayed
L	=$(IDA)libbor.os2\				# libraries directory
TL	=$(IDA)$(TV)libbor.os2\		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
!if  !$d(IM)
R	=$(R)os2\					# results directory
!endif
F	=bor.os2\					# object files directory
B	=2.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.mp2						# map file extension
T	=.ar2						# library flag file extension
IDP	=.bll						# IDP extension
LDR     =.ldo                                           # LDR extension
PLUGIN  =.pl2                                           # PLUGIN extension
DLLEXT  =.dll
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.ap2						# API definition file extension
DEF	=.df2						# DEF file extension
IDPSTUB	=$(BC2)lib\c02d				        # STUB file for IDPs
LDRSTUB =$(BC2)lib\c02d				        # STUB file for LDRs
IDPSLIB =						# system libraries for IDPs
AR	=$(RS)ar$(BS) _a _e$(T) "_l$(BC2)bin\tlib /C/0/E/P64" ruv # librarian
#############################################################################
!else
!error		Unknown compiler/platform
!endif
#############################################################################

!if 0		# this is for makedep
F=
CFLAGS=+$(IDA)dosbor.cfg
!endif

HC=$(RS)hc$(BS)					# Help Compiler
RM=$(R)rm					# File Remover

IDALIB=$(L)ida$(A)

HLIB=$(H)_ida.hlp

# IDC directory

RI=$(R)idc\                                     # IDC directory

########################################################################
!ifdef __WATCOMC__
WD=-D__WATCOMC__
!endif

!if   $d(__MSDOS__)
MAKEFLAGS=$(WD) -D__MSDOS__ -U__NT__
!elif $d(__NT__)
MAKEFLAGS=$(WD) -U__MSDOS__ -D__NT__
!else
MAKEFLAGS=$(WD) -U__MSDOS__ -U__NT__
!endif

########################################################################
!ifdef __WATCOMC__
.cpp$(O):
        $(CC) $(CFLAGS) $<
.c$(O):
        $(CC) $(CFLAGS) $<
.asm$(O):
        $(ASM) $(AFLAGS) /fo=$(F)$* $*
!else					# assume Borland

!ifndef CONLY
CONLY=-c
!endif

.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.asm$(O):
        $(ASM) $(AFLAGS) $*,$(F)$*
!endif

.hls.hhp:
	$(HC) -t $(HLIB) -i$@ $?
$(API)$(DEF):
	$(RS)api2df$(BS) $(APISW) $? $@
$(DEF)$(A):
	$(IMPLIB) $@ temp.def >nul
########################################################################
