/*

        *** For non-Unix systems ***

        This program calls Watcom wlink command
        with correctly generated response file.

        It also calls TLINK (BCC) if compiled with BCC

 ver    Created 25-Jun-95 by I. Guilfanov.

 2.0    adapted for BCC

*/

#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <ctype.h>

char line[512];

int verbose = 1;
int isbor = 0;                          /* for borland */

static char rspname[100] = "rsptmp";

static char *getsw(void);
static int prc1(char *file);            /* Process indirect file */
static int run(char *line);
/*------------------------------------------------------------------------*/
int main(int argc,char *argv[]) {
  char *sw;
  int code;
  int i;
  char *linker = "wlink";

#define SW_CHAR '_'

  while ( argc > 1 && *argv[1] == SW_CHAR ) {
    switch( argv[1][1] ) {
      case 'b':
        isbor = 1;
        linker = "tlink ";
        break;
      case 'l':
        linker = &argv[1][2];
        break;
      default:
        fprintf(stderr,"ld: illegal switch '%c'\n",argv[1][1]);
        return 1;
    }
    argc--;
    argv++;
  }
  sprintf(line,"%s ",linker);

  if ( argc < 2 ) {
    printf(     "ld version 2.0\n"
                "\tUsage: ld [%cl##] [%cb] ...\n"
                "\t %cl - linker name\n"
                "\t %cb - borland style\n",
                SW_CHAR,
                SW_CHAR,
                SW_CHAR,
                SW_CHAR);
    return 1;
  }
  for ( i=1; i < argc; i++ ) {
    if ( argv[i][0] == '@' ) {
      static int first = 1;
      if ( !first ) {
        fprintf(stderr,"ld: only one indirect file is allowed\n");
        return 1;
      }
      first = 0;
      code = prc1(&argv[i][1]);
      if ( code != 0 ) return code;
      strcat(line," @");
      strcat(line,rspname);
      continue;
    }
    strcat(line," ");
    strcat(line,argv[i]);
  }
  if ( verbose ) printf("ld: %s\n",line);
  code = run(line);
  unlink(rspname);
  return code;
}

static char fl[4096];

/*------------------------------------------------------------------------*/
static int prc1(char *file) {           /* Process indirect file */
  FILE *fpo;
  FILE *fp = fopen(file,"r");
  if ( fp == 0 ) {
    fprintf(stderr,"ld: can't open indirect file\n");
    return 1;
  }
  fpo = fopen(tmpnam(rspname),"w");
  if ( fpo == 0 ) {
    fprintf(stderr,"ld: can't create temp file\n");
    return 1;
  }
  while ( fgets(fl,sizeof(fl),fp) ) {
    if ( strncmp(fl,"file",4) == 0 ||
         strncmp(fl,"lib",3) == 0 ) {
      char *ptr = fl;
      while ( *ptr != ' ' && *ptr != '\t' && *ptr != 0 ) ptr++;
      while ( *ptr == ' ' || *ptr == '\t' ) ptr++;
      if ( isbor ) {
        fputs(ptr,fpo);
        continue;
      }
      *(ptr-1) = '\0';
      while ( 1 ) {
        while ( isspace(*ptr) ) ptr++;
        if ( *ptr == '\0' ) break;
        fputs(fl,fpo);
        putc(' ',fpo);
        while ( *ptr != ' ' && *ptr != '\t' && *ptr != 0 ) putc(*ptr,fpo),ptr++;
        putc('\n',fpo);
      }
      continue;
    }
    if ( !isbor ) fputs(fl,fpo);
  }
  fclose(fp);
  fclose(fpo);
  return 0;
}

/*---------------------------------------------------------------------*/
static int run(char *line) {
  char *nargv[32];
  char *ptr = line;
  int i;
  for ( i=0; i < 31; i++ ) {
    while ( *ptr == ' ' || *ptr == '\t' ) ptr++;
    if ( *ptr == '\0' ) break;
    nargv[i] = ptr;
    if ( *ptr == '"' )
      while ( *ptr != '"' && *ptr != '\0' ) {
        if ( *ptr == '\\' ) memmove(ptr,ptr+1,strlen(ptr));
        ptr++;
      }
    else
      while ( *ptr != ' ' && *ptr != '\t' && *ptr != '\0' ) ptr++;
    if ( *ptr != '\0' ) *ptr++ = '\0';
  }
  nargv[i] = NULL;
  i = spawnvp(P_WAIT,nargv[0],nargv);
  if ( i == -1 ) {
    perror("exec error");
    exit(3);
  }
  return i;
}
