/*
 *      Interactive disassembler (IDA).
 *      Version 3.06
 *      Copyright (c) 1990-96 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              FIDO:   2:5020/209
 *                              E-mail: ig@estar.msk.su
 *
 */

#ifndef _ITYPE_HPP
#define _ITYPE_HPP

typedef ulong strid_t;                  // id of a type
typedef ushort *typeid_t;               // type information

#define BADID           (-1LU)
#define MAXTIDLEN       (250/sizeof(ushort))
#define TAGSIZE         (sizeof(strid_t)/sizeof(ushort))

// functions to work with strid/typeid:

strid_t         new_strid(const char *name,typeid_t t);
strid_t         get_strid_by_name(const char *name);
char *          get_strid_name(strid_t id);
int             set_strid_name(strid_t id,const char *name);    // 1 - ok
int             pd_del_strid(strid_t id);                  // 1 - ok
typeid_t        get_tid(strid_t id);
int             set_tid(strid_t id,typeid_t t);         // 1 - ok
int             is_equiv_tid(typeid_t t1,typeid_t t2);

// show to user/get from user

enum absdecl_t { abs_yes, abs_no, abs_unk };

int             get_tid_abs_length(typeid_t t); // -1 - bad tid
int             get_tid_length(typeid_t t);     // -1 - bad tid
strid_t         TidVarId(typeid_t t);

error_t         Tid2User(typeid_t p,char *ubuf);
error_t         User2Tid(const char *ubuf,absdecl_t isabs,typeid_t t);
int             DisplayId(strid_t id);          // returns overflow

// iterate strid...

ulong           NumberOfIds(void);
strid_t         IdNth(long n);
strid_t         FirstId(void);
strid_t         LastId(void);
strid_t         NextId(strid_t current);
strid_t         PrevId(strid_t current);

//  each item is immediately followed by its name id
//
//  uint radix:4;               // representation

#define BTR_MASK        0x0007

#define BTR_DEF         0x0000  // default representation
#define BTR_HEX         0x0001
#define BTR_OCT         0x0002
#define BTR_DEC         0x0003
#define BTR_BIN         0x0004
#define BTR_CHR         0x0005
#define BTR_FLO         0x0006  // float
#define BTR_OTH         0x0007  // r50 and other types

#define BT_CONST        0x0008

#define BTS_MASK        0x00F0
#define BTS_UNKNOWN     0X0000  // undefined item
#define BTS_VOID        0x0010
#define BTS_CHAR        0x0020
#define BTS_INT         0x0030
#define BTS_LONG        0x0040
#define BTS_FLOAT       0x0050
#define BTS_DOUBLE      0x0060

#define BTS_ARRAY       0x0070  // followed by btype & sizes (hex),end with -1
#define BTS_PTR         0x0080
#define BTS_ENUM        0x0090  // id member list is ended by BADID
#define BTS_STRUCT      0x00A0  // member list is ended by BTS_END
#define BTS_UNION       0x00B0  // member list is ended by BTS_END
#define BTS_STRID       0x00C0  // followed by strid_t
#define BTS_FUNC        0x00D0  // followed by return type and arglist
                                // arglist ends with BTS_END
#define BTS_VALIST      0x00E0
#define BTS_END         (BTS_VOID)

#define BTP_MASK        0x7000  //              Pointers........................Plain Data......Function
#define BTP_DEF         0x0000  // unknown pointer type, followed by btype
#define BTP_TINY        0x1000  // 8-bit offset,  followed by base & btype      ?               no return
#define BTP_NEAR        0x2000  // 16-bit offset, followed by base & btype      ?               retn
#define BTP_FAR         0x3000  // 16:16          followed by        btype      ?               retf
#define BTP_FLAT        0x4000  // 32-bit offset, followed by base & btype      ?               retf
#define BTP_HUGE        0x5000  // 16:32          followed by        btype      ?               retf

#define BT_VOLATILE     0x0100
#define BT_SHORT        0x0200
#define BT_LONG         0x0400
#define BT_UNSIGNED     0x0800
#define BT_SIGNED       0x8000

#define SCALAR_MODIFIERS        (BT_SHORT|BT_LONG|BT_SIGNED|BT_UNSIGNED)

inline int baseType(ushort btype) { return (btype & BTS_MASK); }
inline int ptrType (ushort btype) { return (btype & BTP_MASK); }
inline int radType (ushort btype) { return (btype & BTR_MASK); }

// char *ptr;
//      BTS_PTR,BTS_CHAR,id(ptr)
//
// fprintf(FILE*fp,const char *format,...);
//      BTS_FUNC,id(fprintf)
//      BTS_INT
//      BTS_PTR,BTS_STRID,id(FILE),id(fprintf::fp)
//      BTS_PTR,BTS_CHAR|BT_CONST,id(fprintf::format)
//      BTS_VALIST
//      BTS_END

// void memcpy(void *x,void *y,int z);
//      BTS_FUNC,id(memcpy)
//      BTS_VOID
//      BTS_PTR,BTS_VOID,id(memcpy::x)
//      BTS_PTR,BTS_VOID,id(memcpy::y)
//      BTS_INT,id(memcpy::z)
//      BTS_END

// struct x {
//   int x;
//   long z;
//   int (*f)(void);
// };
//      BTS_STRUCT,id(x)
//              BTS_INT,id(x::x)
//              BTS_LONG,id(x::z)
//              BTS_PTR,id(x::f)
//               BTS_FUNC,badid
//                BTS_INT
//                BTS_VOID
//                BTS_END
//      BTS_END

// typedef struct x *myptr;

// typeid of myptr points to:  BTS_PTR,badid,BTS_STRID,id(x)

#endif // _ITYPE_HPP
