/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-97 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su
 *                              FIDO:   2:5020/209
 *
 */

#ifndef _PRODIR_H
#define _PRODIR_H

//
//      This file contains unified interface to findfirst/findnext/findclose
//      functions.
//      You may continue to use find...() functions as you would do in BCC.
//      (don't forget to call findclose(), though)
//

#ifdef __WATCOMC__
#  include <dos.h>
#  include <direct.h>
#  define MAXPATH               _MAX_PATH
#  define MAXDRIVE              _MAX_DRIVE
#  define MAXDIR                _MAX_DIR
#  define MAXFILE               _MAX_FNAME
#  define MAXEXT                _MAX_EXT
#  define FA_DIREC              _A_SUBDIR
#  define FA_RDONLY             _A_RDONLY
#  define FA_ARCH               _A_ARCH
#  define findnext              _dos_findnext
#  define findfirst(p,blk,attr) _dos_findfirst(p,attr,blk)
#  define ffblk                 struct find_t
#  define ff_attrib             attrib
#  define ff_name               name
#  define findclose(p)          _dos_findclose( p )
#else
#  include <dir.h>
#if __BORLANDC__ < 0x0540 
#  define findclose(p)
#endif
#endif

#endif // _PRODIR_H
