/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su, ig@datarescue.com
 *                              FIDO:   2:5020/209
 *
 */

#ifndef _ENTRY_HPP
#define _ENTRY_HPP
#pragma pack(push, 1)

//
//      This file contains functions that deal with entry points
//      IDA maintains list of entry points to the program
//      Each entry point
//        - has an address
//        - has a name
//        - may have ordinal number
//

// Get number of entry points

idaman int ida_export get_entry_qty(void);

// Add an entry point to the list of entry points.
//      ord      - ordinal number
//                 if ordinal number is equal to 'ea' then ordinal is not used
//      ea       - linear address
//      name     - name of entry point. If the specified location already
//                 has a name, the old name will be appended to a repeatable
//                 comment. If name == NULL, then the old name will be retained.
//      makecode - should the kernel convert bytes at the entry point
//                 to instruction(s)

idaman int ida_export add_entry(ulong ord,ulong ea,const char *name,int makecode);


// Get ordinal number of an entry point
//      idx - internal number of entry point. Should be
//            in the range 0..get_entry_qty()-1
// returns: ordinal number or 0.

idaman ulong ida_export get_entry_ordinal(ulong idx);


// Get entry point address by its ordinal
//      ord - ordinal number of entry point
// returns: address or BADADDR

idaman ulong ida_export get_entry(ulong ord);


// Get name of the entry point by its ordinal
//      ord - ordinal number of entry point
// returns: name or NULL

idaman char *ida_export get_entry_name(ulong ord);


// Rename entry point
//      ord      - ordinal number of the entry point
//      name     - name of entry point. If the specified location already
//                 has a name, the old name will be appended to a repeatable
//                 comment.
// returns: 1-ok, 0-failure

idaman int ida_export rename_entry(ulong ord,const char *name);



// init/term (for the kernel)

void init_entries(void);
void term_entries(void);

#pragma pack(pop)
#endif // _ENTRY_HPP
