#
#       Common part of make files for IDA.
#
#       Please set IDA and BCDIR variables!
#

#       All makesfiles are prepared to be used by BCC MAKE.EXE

#--------------------------- Main IDA directory   --------------------------
!ifndef IDA
IDA=z:\newsdk\          # with the trailing backslash!
!endif

!ifndef BCDIR
BCDIR=c:\progra~1\borland\cbuild~1\  # BCC directory
!endif

############################################################################
!ifndef BC5_COM
BC5_COM=$(BCDIR)
!endif
TV=ui\txt\tv\           # TurboVision subdirectory

.PHONY: all All goal Goal total Total objdir $(ADDITIONAL_GOALS)

######################### set debug switches
DEBUG=1
!ifdef DEBUG
CCDEBUG= -v
CCNOOPT= -O-
!endif

!ifdef __EA64__
ADRSIZE=64
ADRSWITCH=-D__EA64__
!else
ADRSIZE=32
!endif

# include and help directories are common for all platforms and compilers:
I=$(IDA)include\\
H=$(IDA)bin\            # help file is stored in the bin directory
HS=.hls                 #       help source
HH=.hhp                 #       help headers

#############################################################################
RS      =$(IDA)bin\                                     # host utilities directory
C       =$(RS)cfg\					# cfg files

#############################################################################
!if $d(__MSDOS__)					# Borland C++ DOS 16
__IDA_MSDOS__=1
__DOS16__=1
BC31=c:\bcc\                                            # Borland directory
IMPLIB	=$(BC31)bin\implib.exe				# implib executable name
ASM	=$(BC31)bin\tasm.exe				# assembler
!ifdef LDR_TRANSLATION
CC	=$(BCDIR)bin\bcc.exe				# C++ compiler
!else
CC	=$(BC31)bin\bcc.exe			        # C++ compiler
!endif
CFLAGS	=+$(IDA)dosbor.cfg $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/t/ml/z/m5$(_AFLAGS)				# default assembler flags
OUTSW	=-e						# outfile name switch for one-line linker
OUTDLL	=/Twd						# output is DLL switch
LINKER	=$(BC31)bin\tlink /m $(_LDFLAGS)		# indirect file linker
CCL	=$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=$(BC31)lib\c0l				# indirect linker: C startup file
C_LIB	=$(BC31)lib\cl					# indirect linker: default C library
OVRON	=-Yo						# 16bit: following files overlayed
OVROFF	=-Yo-						# 16bit: following files not overlayed
L	=$(IDA)lib\					# libraries directory
TL	=$(IDA)$(TV)lib\       		        	# TVision libraries directory
R	=$(IDA)$(IM)bin\				# results directory
F	=						# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.map						# map file extension
T	=.ar						# library flag file extension
IDP	=.idp						# IDP extension
LDR     =.ldd                                           # LDR extension
PLUGIN  =.pl1                                           # PLUGIN extension
DLLEXT  =$(B)
LINKOPTS_EXE=/ye+/yx+/c
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
API	=.api						# API definition file extension
DEF	=.def						# DEF file extension
IDPSTUB	=$(L)idpstub$(O)				# STUB file for IDPs
LDRSTUB =$(L)idpstub$(O) $(L)dlldata$(O)                # STUB file for LDRs
IDPSLIB =						# system libraries for IDPs
AR	=$(RS)ar$(BS) _a _e$(T) "_l$(BC31)bin\tlib /C/0/E" ruv	# librarian
APISW   =-sdos16
#############################################################################
!elif $d(__NT__)                                        # Borland C++ for NT (WIN32)
IMPLIB  =$(BCDIR)bin\implib                             # implib executable name
ASM     =$(BC5_COM)bin\tasm32                           # assembler
CC      =$(BCDIR)bin\bcc32                              # C++ compiler
!ifdef __IDP__
CC_ALIGN= -ps                                           # Standard calling convention
!else
CC_ALIGN= -pr                                           # Register calling convention
!endif
!ifdef __PRECOMPILE__
CC_PRECOMPILE= -H
!endif
CFLAGS  =+$(IDA)w$(ADRSIZE)bor.cfg $(ADRSWITCH) $(CC_PRECOMPILE) $(CC_ALIGN) $(_CFLAGS) $(CCDEBUG) $(CCNOOPT) # default compiler flags
AFLAGS  =/D__FLAT__ /t/ml/m5$(_AFLAGS)                  # default assembler flags
OUTSW   =-n -e                                          # outfile name switch for one-line linker
OUTDLL  =/Tpd                                           # output is DLL switch
!ifdef BASE
NT_BSW  =-b=$(BASE)
!endif
LDFLAGS =$(NT_BSW) -Gn $(_LDFLAGS)
LINKER  =$(BCDIR)bin\ilink32 $(LDFLAGS) $(CCDEBUG)      # indirect file linker
CCL     =$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)       # one-line linker
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=c0x32                                         # indirect linker: C startup file
C_IMP   =import32                                       # import library
C_LIB   =$(C_IMP) cw32mt                                # indirect linker: default C library
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
L       =$(IDA)libbor.w$(ADRSIZE)\                      # libraries directory
TL      =$(IDA)$(TV)libbor.w32\                         # TVision libraries directory
R       =$(IDA)$(IM)bin\                                # results directory
F       =bor.w$(ADRSIZE)\                               # object files directory
!ifdef __EA64__
B       =64.exe                                         # exe file extension
!else
B       =.exe                                           # exe file extension
!endif
BS      =.exe                                           # host utility extension
MAP     =.mpb                                           # map file extension
T       =.a$(ADRSIZE)                                   # library flag file extension
IDP     =.w$(ADRSIZE)                                   # IDP extension
!ifdef __EA64__
DLLEXT  =64.wll
IDP     =64.w$(ADRSIZE)                                 # IDP extension
LDR     =64.l$(ADRSIZE)                                 # LDR extension
PLUGIN  =.p$(ADRSIZE)                                   # PLUGIN extension
!else
DLLEXT  =.wll
LDR     =.ldw
PLUGIN  =.plw
!endif
ORDINALS= #-o                                           # import functions by ordinals
# -c case sensitive
# -C clear state before linking
# -s detailed map of segments
# -m detailed map of publics
# -r verbose
LINKOPTS_EXE=-m -c -C $(ORDINALS) $(CCDEBUG) -L$(BCDIR)lib
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
API     =.api                                           # API definition file extension
DEF     =.df2                                           # DEF file extension
!if  !$d(NORTL)
IDPSTUB =$(BCDIR)lib\c0d32                              # STUB file for IDPs
LDRSTUB =$(BCDIR)lib\c0d32                              # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(L)modstart                                   # STUB file for IDPs
LDRSTUB =$(L)modstart                                   # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _a _e$(T) "_l$(BC5_COM)BIN\TLIB.EXE /C/E/P64" ruv   # librarian
APISW   =-swin -i$(R)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=-P-
!endif
#############################################################################
!else
!error          Unknown compiler/platform
!endif
#############################################################################

!if 0           # this is for makedep
F=
!endif

HC=$(RS)hc$(BS)                                 # Help Compiler
RM=del                                          # File Remover
MKDIR=-@mkdir
CP=copy
MV=move

IDALIB=$(L)ida$(A)
DUMB=$(L)dumb$(O)
HLIB=$(H)_ida.hlp

# IDC directory

RI=$(R)idc\                                     # IDC directory

########################################################################
!if   $d(__MSDOS__)
MAKEFLAGS=-D__MSDOS__ -U__NT__
!elif $d(__NT__)
MAKEFLAGS=-U__MSDOS__ -D__NT__
!else
MAKEFLAGS=-U__MSDOS__ -U__NT__
!endif

########################################################################
!ifndef CONLY
CONLY=-c
!endif

.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) $(FORCEC) {$< }
.asm$(O):
        $(ASM) $(AFLAGS) $*,$(F)$*

.hls.hhp:
        $(HC) -t $(HLIB) -i$@ $?
$(API)$(DEF):
        $(RS)api2df$(BS) $(APISW) $? $@
$(DEF)$(A):
        $(IMPLIB) $@ temp.def >nul
########################################################################
