/*
 *      Interactive disassembler (IDA).
 *      Copyright (c) 1990-97 by Ilfak Guilfanov.
 *      ALL RIGHTS RESERVED.
 *                              E-mail: ig@estar.msk.su
 *                              FIDO:   2:5020/209
 *
 */

#ifndef _PRODIR_H
#define _PRODIR_H
#pragma pack(push, 1)

//
//      This file contains unified interface to findfirst/findnext/findclose
//      functions.
//      You may continue to use find...() functions as you would do in BCC.
//      (don't forget to call findclose(), though)
//
//      It is better to use enumerate_files() from diskio.hpp
//

#if defined(__MSDOS__) || defined(__OS2__) || defined(__NT__)
#define __FAT__
#define DIRCHAR '\\'
#define DRVCHAR ':'
#else
#define DIRCHAR '/'
#endif
#define EXTCHAR '.'

#if defined(__WATCOMC__) || defined(_MSC_VER)

#  include <dos.h>
#  include <direct.h>
#  define MAXPATH               _MAX_PATH
#  define MAXDRIVE              _MAX_DRIVE
#  define MAXDIR                _MAX_DIR
#  define MAXFILE               _MAX_FNAME
#  define MAXEXT                _MAX_EXT
#  define FA_DIREC              _A_SUBDIR
#  define FA_RDONLY             _A_RDONLY
#  define FA_ARCH               _A_ARCH
#  define findnext              _dos_findnext
#  define findfirst(p,blk,attr) _dos_findfirst(p,attr,blk)
#  define ffblk                 struct find_t
#  define ff_attrib             attrib
#  define ff_name               name
#  define findclose(p)          _dos_findclose( p )

#elif defined(__GNUC__) // unix systems

struct ffblk
{
// user fields:
  int ff_attrib;
  char ff_name[QMAXPATH];
// private fields:
  void *filelist;
  int fileidx, fileqty;
  char dirpath[QMAXPATH];
  char pattern[QMAXPATH];
  int attr;
};

idaman int ida_export findfirst(const char *fname, ffblk *blk, int attr);
idaman int ida_export findnext(ffblk *blk);
idaman void ida_export findclose(ffblk *blk);
#define MAXPATH               QMAXPATH
#define MAXDIR                QMAXPATH
#define MAXFILE               QMAXPATH
#define MAXEXT                QMAXPATH
#define FA_DIREC              S_IFDIR

#else

#  include <dir.h>
#if __BORLANDC__ < 0x0540
#  define findclose(p)
#endif

#endif

#ifdef __LINUX__
#define FA_FULL 0
#else
#define FA_FULL (_A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_ARCH)
#endif


#pragma pack(pop)
#endif // _PRODIR_H
