
bool elf64;
ushort e_type;

static bool mf;
static FILE *fp;
static char name[MAXSTR];
static ulong dynstr_off, dynstr_size;
static ulong dynsym_off, dynsym_size;
static ulong dynrel_off, dynrel_size;
static ulong dynrela_off, dynrela_size;
static uval_t e_shoff;
static ushort e_shnum, e_shstrndx;

#ifndef NO_ERRSTRUCT
//--------------------------------------------------------------------------
static void ask_for_exit(const char *str)
{
  if ( askyn_c(1, "%s. Continue?", str) <= 0 )
    qexit(1);
}

//--------------------------------------------------------------------------
static void _errstruct(int line)
{
  static bool asked = false;
  if ( !asked )
  {
    if ( askyn_c(1, "Bad file structure or read error (line %d). Continue?", line)
                <= 0 ) qexit(1);
    asked = true;
  }
}

#define errstruct() _errstruct(__LINE__)
#endif

//--------------------------------------------------------------------------
static void errnomem(void) { nomem("ELF"); }

//--------------------------------------------------------------------------
// FILE-MEMORY mapping
struct mapping_t
{
  ulong offset;
  ulong size;
  uint64 ea;
};

static mapping_t *map = NULL;
static int nmap = 0;

static void add_mapping(ulong offset, ulong size, uint64 ea)
{
  map = (mapping_t *)qrealloc(map, (nmap+1)*sizeof(mapping_t));
  if ( map == NULL ) errnomem();
  map[nmap].offset = offset;
  map[nmap].size   = size;
  map[nmap].ea     = ea;
  nmap++;
}

static void clear_mappings(void)
{
  qfree(map);
  map = NULL;
  nmap = 0;
}

static ulong map_ea(uint64 ea)
{
  for ( int i=0; i < nmap; i++ )
  {
    if ( map[i].ea <= ea && map[i].ea+map[i].size > ea )
      return low(ea - map[i].ea) + map[i].offset;
  }
  char buf[64];
  warning("Couldn't map address %s", print(ea, buf, sizeof(buf), 16));
  return low(ea);
}

//--------------------------------------------------------------------------
//      Functions common for EFD & DEBUGGER
//--------------------------------------------------------------------------

static Elf32_Shdr   *shdr32;
static Elf64_Shdr   *shdr64;
static ulong        symcnt;

static ushort got_sec, plt_sec, str_sec, sym_sec, dst_sec, dsm_sec, int_sec;

static ulong dyn_offset, dyn_size;
static int dyn_link;

static sym_rel *stb, *dstb;


//--------------------------------------------------------------------------
bool is_elf_file(FILE *fp)
{
  Elf32_Ehdr h;
  eseek(fp, 0);
  if ( qfread(fp, &h, sizeof(h)) != sizeof(h)
    || h.e_ident[EI_MAG0] != ELFMAG0
    || h.e_ident[EI_MAG1] != ELFMAG1
    || h.e_ident[EI_MAG2] != ELFMAG2
    || h.e_ident[EI_MAG3] != ELFMAG3 ) return false;
  return true;
}

//--------------------------------------------------------------------------
static void load_sht32(void)
{
  register int i;
  register Elf32_Shdr *sh;

  eseek(fp, e_shoff);
  for(i = 0, sh = shdr32; i < e_shnum; i++, sh++) {
    if(fread4bytes(fp,          &sh->sh_name,      mf) ||
       fread4bytes(fp,          &sh->sh_type,      mf) ||
       fread4bytes(fp,          &sh->sh_flags,     mf) ||
       fread4bytes(fp, (ulong *)&sh->sh_addr,      mf) ||
       fread4bytes(fp,          &sh->sh_offset,    mf) ||
       fread4bytes(fp,          &sh->sh_size,      mf) ||
       fread4bytes(fp,          &sh->sh_link,      mf) ||
       fread4bytes(fp,          &sh->sh_info,      mf) ||
       fread4bytes(fp,          &sh->sh_addralign, mf) ||
       fread4bytes(fp,          &sh->sh_entsize,   mf))  errstruct();
  }
}

//--------------------------------------------------------------------------
static void load_sht64(void)
{
  register int i;
  register Elf64_Shdr *sh;

  eseek(fp, e_shoff);
  for(i = 0, sh = shdr64; i < e_shnum; i++, sh++) {
    if(fread4bytes(fp, &sh->sh_name,      mf) ||
       fread4bytes(fp, &sh->sh_type,      mf) ||
       fread8bytes(fp, &sh->sh_flags,     mf) ||
       fread8bytes(fp, &sh->sh_addr,      mf) ||
       fread8bytes(fp, &sh->sh_offset,    mf) ||
       fread8bytes(fp, &sh->sh_size,      mf) ||
       fread4bytes(fp, &sh->sh_link,      mf) ||
       fread4bytes(fp, &sh->sh_info,      mf) ||
       fread8bytes(fp, &sh->sh_addralign, mf) ||
       fread8bytes(fp, &sh->sh_entsize,   mf))  errstruct();
  }
}

//--------------------------------------------------------------------------
static void read_dyninfo(ulong offset, ulong size)
{
  eseek(fp, offset);
  const int entsize = elf64 ? sizeof(Elf64_Dyn) : sizeof(Elf32_Dyn);
  for(int i = 1; i < size; i += entsize )
  {
    Elf64_Dyn dyn;
    if ( elf64 )
    {
      if(fread8bytes(fp, &dyn.d_tag, mf) ||
         fread8bytes(fp, &dyn.d_un, mf))  errstruct();
    }
    else
    {
      ulong tag, val;
      if(fread4bytes(fp, &tag, mf) ||
         fread4bytes(fp, &val, mf))  errstruct();
      dyn.d_tag = tag;
      dyn.d_un = val;
    }
    switch ( WC4(dyn.d_tag) )
    {
      case DT_STRTAB:
        dynstr_off = map_ea(dyn.d_un);
        break;
      case DT_SYMTAB:
        dynsym_off = map_ea(dyn.d_un);
        break;
      case DT_REL:
        dynrel_off = map_ea(dyn.d_un);
        break;
      case DT_RELA:
        dynrela_off = map_ea(dyn.d_un);
        break;
      case DT_STRSZ:
        dynstr_size = WC4(dyn.d_un);
        break;
      case DT_RELSZ:
        dynrel_size = WC4(dyn.d_un);
        break;
      case DT_RELASZ:
        dynrela_size = WC4(dyn.d_un);
        break;
    }
  }
  ulong off = dynstr_off;
  if ( dynrel_off  ) off = qmin(dynrel_off, off);
  if ( dynrela_off ) off = qmin(dynrela_off, off);
  dynsym_size = off - dynsym_off;
}

//--------------------------------------------------------------------------
static bool load_name2(ushort index, ulong offset)
{
  uint64 off, size;
  if ( index == ushort(-1) )
  {
    off = dynstr_off;
    size = dynstr_size;
  }
  else
  {
    off  = elf64 ? shdr64[index].sh_offset : shdr32[index].sh_offset;
    size = elf64 ? shdr64[index].sh_size   : shdr32[index].sh_size;
  }
  if ( offset >= size )
  {
    qsnprintf(name, sizeof(name), "bad offset %08lx", low(offset+off));
    return false;
  }
  ulong pos = qftell(fp);
  offset = low(offset + off);
  eseek(fp, offset);

  register char *p;
  register int  i, j;
  bool ok = true;
  for(i = 0, p = name; i < sizeof(name)-1; i++, p++)
    if((j = qfgetc(fp)) == EOF)
    {
      strcpy(p, "{truncated name}");
      ok = false;
      break;
    }
    else if((*p = (char)j) == '\0') break;
  if(i == sizeof(name)-1)
  {
    strcpy(p-5, "...");
    ok = false;
  }
  eseek(fp, pos);
  return ok;
}

//--------------------------------------------------------------------------
template<class Elf32_Shdr>
static void get_section_name(Elf32_Shdr *sh)
{
    if(e_shstrndx) load_name2(e_shstrndx, sh->sh_name);
    else if(sh->sh_size != 0) name[0] = '\0'; //nonamed sections ?
}

//--------------------------------------------------------------------------
template<class Elf32_Shdr>
static void analyse_sht(Elf32_Shdr *sh)
{
  int i;

  for(i = 1, sh++; i < e_shnum; i++, sh++)
  {
    if(sh->sh_size==0 && (e_type != ET_REL ||  //skip zero segment's
       (sh->sh_type != SHT_PROGBITS && sh->sh_type != SHT_NOBITS))) continue;

    if ( sh->sh_size == 0 ) continue;
    get_section_name(sh);
    switch(sh->sh_type) {
      case SHT_STRTAB:
        if(!strcmp(name, ".strtab"))
          str_sec = i;
        else if(!strcmp(name, ".dynstr"))
          dst_sec = i;
        break;

      case SHT_DYNAMIC:
      case SHT_DYNSYM:
      case SHT_SYMTAB:
          switch(sh->sh_type)
          {
            case SHT_SYMTAB:
              sym_sec = i;
              symcnt += low(sh->sh_size);
              break;
            case SHT_DYNSYM:
              dsm_sec = i;
              symcnt += low(sh->sh_size);
              break;
            case SHT_DYNAMIC:
              dyn_offset = sh->sh_offset;
              dyn_size   = sh->sh_size;
              dyn_link   = sh->sh_link;
              break;
          }
          break;

      case SHT_PROGBITS:
        if(!strcmp(name, ".interp"))
        {
          int_sec = i;
          break;
        }
        if(!strcmp(name, ".got"))
        {
          got_sec = i;
          break;
        }
        // no break
      case SHT_NOBITS:
        if(!strcmp(name, ".plt")) plt_sec = i;
        break;
    }
  }
}

