
//-----------------------------------------------------------------------
bool is_intelomf_file(FILE *fp)
{
  uchar magic;
  lmh h;
  eseek(fp, 0);
  if ( qfread(fp, &magic, sizeof(magic)) != sizeof(magic)
    || qfread(fp, &h, sizeof(h)) != sizeof(h) ) return false;
  int fsize = qfilelength(fileno(fp));
  return magic == INTELOMF_MAGIC_BYTE
      && h.tot_length < fsize;
}

//-----------------------------------------------------------------------
static int read_pstring(FILE *fp, char *name, int size)
{
  char buf[256];
  uchar nlen;
  lread(fp, &nlen, sizeof(nlen));
  lread(fp, buf, nlen);
  buf[nlen] = '\0';
  qstrncpy(name, buf, size);
  return nlen;
}

//-----------------------------------------------------------------------
static ulong readdw(const uchar *&ptr, bool wide)
{
  ulong x;
  if ( wide )
  {
    x = *(ulong *)ptr;
    ptr += sizeof(ulong);
  }
  else
  {
    x = *(ushort *)ptr;
    ptr += sizeof(ushort);
  }
  return x;
}

