/*
 *  This Loader Module is written by Yury Haron
 *
 */

/*
        L O A D E R  for Java-classFile
*/

#include "../idaldr.h"
#include "../../module/java/classfil.hpp"
//--------------------------------------------------------------------------
//
//      check input file format. if recognized, then return 1
//      and fill 'fileformatname'.
//      otherwise return 0
//
int accept_file(FILE *fp, char fileformatname[MAX_FILE_FORMAT_NAME], int n)
{
  ulong  magic;
  ushort min_ver, maj_ver;

  if(n ||
     fread4bytes(fp, &magic, 1) || magic != MAGICNUMBER ||
     fread2bytes(fp, &min_ver, 1) || fread2bytes(fp, &maj_ver, 1) ||
     maj_ver < CURRENT_MAJOR_VERSION || maj_ver > (CURRENT_MAJOR_VERSION+1))
          				                             return(0);

  strncpy(fileformatname, "JavaVM Class File", MAX_FILE_FORMAT_NAME);
  return(f_LOADER);
}

//--------------------------------------------------------------------------
//
//      load file into the database.
//
void load_file(FILE *fp, ushort neflag, const char * /*fileformatname*/)
{
  if(ph.id != PLFM_JAVA )
    set_processor_type("java", SETPROC_ALL|SETPROC_FATAL);
  if(ph.notify(ph.loader, fp, (bool)(neflag & NEF_MAN)))
                    error("Internal error in loader<->module link");
}

//----------------------------------------------------------------------
//
//      LOADER DESCRIPTION BLOCK
//
//----------------------------------------------------------------------
loader_t LDSC =
{
  IDP_INTERFACE_VERSION,
  0,                            // loader flags
//
//      check input file format. if recognized, then return 1
//      and fill 'fileformatname'.
//      otherwise return 0
//
  accept_file,
//
//      load file into the database.
//
  load_file,
//
//      create output file from the database.
//      this function may be absent.
//
  NULL,
};
