#ifndef _CLASSFIL_HPP_
#define _CLASSFIL_HPP_
//
// Java File definition
//
#define MAGICNUMBER     0xcafebabeUL    // magic number
#define CURRENT_MAJOR_VERSION   45
//
// access_flags
//
#define ACC_PUBLIC         0x0001  //Visible to everyone
#define ACC_PRIVATE        0x0002  //Visible only to the defning
#define ACC_PROTECTED      0x0004  //Visible to subclasses
#define ACC_STATIC         0x0008  //Variable or method is static Method
#define ACC_FINAL          0x0010  //No further subclassing, overriding, or
                                   //assignment after initialization
#define ACC_SYNCHRONIZED   0x0020  //Wrap use in monitor lock
#define ACC_SUPER          0x0020  //invoke by the 'invokespecial'
#define ACC_VOLATILE       0x0040  //Can't cache
#define ACC_TRANSIENT      0x0080  //Not to be written or read by
                                   //a persistent object manager
#define ACC_NATIVE         0x0100  //Implemented in a language otherthan Java
#define ACC_INTERFACE      0x0200  //Is an interface
#define ACC_ABSTRACT       0x0400  //No body provided
//
#define ACC_FULL_MASK      0x07FF // for out
//
#define FIELD_ACC_MASK (ACC_STATIC | ACC_FINAL | ACC_VOLATILE | ACC_TRANSIENT)
#define ACC_MASK_ONE (ACC_PUBLIC | ACC_PROTECTED | ACC_PRIVATE)
#define METHOD_ACC_MASK (ACC_STATIC | ACC_FINAL | ACC_SYNCHRONIZED | ACC_NATIVE | ACC_ABSTRACT)
// base type
//
#define j_byte          'B'     //signed byte
#define j_char          'C'     //character
#define j_double        'D'     //double precision IEEE float
#define j_float         'F'     //single precision IEEE foat
#define j_int           'I'     //integer
#define j_long          'J'     //long integer
#define j_class         'L'     //<fullclassname>;
                                // ... an object of the given class
#define j_short         'S'     //signed short
#define j_bool          'Z'     //boolean true or false
#define j_array         '['     //<length><field sig> ... array

#define j_void_ret      'V'     // return no value
//
// Constant Pool
//
#define CONSTANT_Utf8                  1  //jdk1.0
#define CONSTANT_Asciz                 1  //jdk1.1
#define CONSTANT_Unicode               2
#define CONSTANT_Integer               3
#define CONSTANT_Float                 4
#define CONSTANT_Long                  5
#define CONSTANT_Double                6
#define CONSTANT_Class                 7
#define CONSTANT_String                8
#define CONSTANT_Fieldref              9
#define CONSTANT_Methodref            10
#define CONSTANT_InterfaceMethodref   11
#define CONSTANT_NameAndType          12
#define MAX_CONSTANT_TYPE     12 // Check in Loader flag
//
// Array Type (newarray)
//
#define T_BOOLEAN       4
#define T_CHAR          5
#define T_FLOAT         6
#define T_DOUBLE        7
#define T_BYTE          8
#define T_SHORT         9
#define T_INT           10
#define T_LONG          11
// addonce for out
#define T_CLASS  (T_LONG+1)
#define T_FIELD  (T_CLASS+1)
#define T_VOID   (T_FIELD+1)
//
// defined additional attribute types
//
#define a_ConstantValue         0x0001
#define a_Code                  0x0002
#define a_Exceptions            0x0004
#define a_SourceFile            0x0008
#define a_LineNumberTable       0x0010
#define a_LocalVariableTable    0x0020
#define a_FULL_attr 0x3F //for strip diagnostic
//
#define a_Field_ATTR            (a_ConstantValue)
#define a_Method_ATTR           (a_Code | a_Exceptions)
#define a_Code_ATTR             (a_LineNumberTable | a_LocalVariableTable)
#define a_Additional_ATTR       (a_SourceFile)
//
#endif
