#include <loader.hpp>

extern debugger_t debugger;
//--------------------------------------------------------------------------
int idaapi start_process(const char *path,
                         const char *args,
                         const char *startdir,
                         ulong input_file_crc32)
{
  // check that the host application has been specified
  if ( is_dll && strcmp(path, get_input_file_path()) == 0 )
  {
    warning("AUTOHIDE NONE\n"
            "Please specify the host application first (Debugger, Process options)");
    return 0;
  }
  bool is_gui = callui(ui_get_hwnd).vptr != NULL;
  return r_start_process(path, args, startdir, is_gui, input_file_crc32);
}

//--------------------------------------------------------------------------
void idaapi stopped_at_debug_event(const debug_event_t *event, bool dlls_added)
{
  if ( dlls_added )
    r_stopped_at_debug_event(event);
}

//--------------------------------------------------------------------------
bool idaapi init_debugger(const char *hostname, int port_num, const char *password)
{
  if ( !open_remote(hostname, port_num, password) )
    return false;
  fix_exception_table(inf.beginEA);
  int code = r_init(is_dll,
                    (debug & IDA_DEBUG_DEBUGGER) != 0,
                    inf.beginEA,
                    get_input_file_path());
  debugger.process_get_info = (code & 1) ? r_process_get_info : NULL;
  debugger.detach_process   = (code & 2) ? r_detach_process : NULL;
  inited = true;
  return true;
}

//--------------------------------------------------------------------------
bool idaapi term_debugger(void)
{
  if ( inited )
  {
    inited = false;
    return close_remote();
  }
  return false;
}

//--------------------------------------------------------------------------
//      Terminate.
//      Usually this callback is empty.
//      The plugin should unhook from the notification lists if
//      hook_to_notification_point() was used.
//
//      IDA will call this function when the user asks to exit.
//      This function won't be called in the case of emergency exits.

void term(void)
{
  if ( inited )
    r_term();
}

//--------------------------------------------------------------------------
//
//      The plugin method
//
//      This is the main function of plugin.
//
//      It will be called when the user selects the plugin.
//
//              arg - the input argument, it can be specified in
//                    plugins.cfg file. The default is zero.
//
//

void run(int arg)
{
  if ( arg == 0 ) return;
  // return pointer to debugger description block
  *((debugger_t* *)arg) = &debugger;
}

char wanted_hotkey[] = "";

//--------------------------------------------------------------------------
//
//      DEBUGGER DESCRIPTION BLOCK
//
//--------------------------------------------------------------------------

debugger_t debugger =
{
  IDD_INTERFACE_VERSION,
  DEBUGGER_ID,
  DEBUGGER_FLAGS,

  register_classes,
  RC_GENERAL,
  registers,
  qnumber(registers),

  MEMORY_PAGE_SIZE,

  debug_instruction,
  qnumber(debug_instruction),

#ifndef DBG_NO_EXCEPTIONS
  exceptions,
  qnumber(exceptions),
#else
  NULL, 0,
#endif

  init_debugger,
  term_debugger,

  NULL, // process_get_info: patched at runtime if ToolHelp functions are available
  start_process,
  r_attach_process,
  NULL, // detach_process:   patched at runtime if Windows XP/2K3
  rebase_if_required_to,
  r_prepare_to_pause_process,
  r_exit_process,

  r_get_debug_event,
  r_continue_after_event,
  stopped_at_debug_event,

  r_thread_suspend,
  r_thread_continue,
  r_thread_set_step,
  thread_read_registers,
  thread_write_register,

  r_get_memory_info,
  r_read_memory,
  r_write_memory,

  r_is_ok_hwbpt,
  r_add_hwbpt,
  r_del_hwbpt,
};

//--------------------------------------------------------------------------
//
//      PLUGIN DESCRIPTION BLOCK
//
//--------------------------------------------------------------------------
plugin_t PLUGIN =
{
  IDP_INTERFACE_VERSION,
  PLUGIN_HIDE|PLUGIN_DBG, // plugin flags

  init,                 // initialize

  term,                 // terminate. this pointer may be NULL.

  run,                  // invoke plugin

  comment,              // long comment about the plugin
                        // it could appear in the status line
                        // or as a hint

  help,                 // multiline help about the plugin

  wanted_name,          // the preferred short name of the plugin
  wanted_hotkey         // the preferred hotkey to run the plugin
};
