
static const uchar bpt_code = 0xCC;  // breakpoint instruction opcode

// Hardware breakpoints

static ea_t hwbpt_ea[MAX_BPT];
static ulong dr6;
static ulong dr7;

//--------------------------------------------------------------------------
// returns -1 if something is wrong
// len == 0 - any size, true/false response
static int find_hwbpt_slot(hwbpt_t type, ea_t ea, int len)
{
  for ( int i=0; i < MAX_BPT; i++ ) // another breakpoint is here
    if ( hwbpt_ea[i] == ea )
      return -1;

  if ( type != HWBPT_RDWR            // type is good?
    && type != HWBPT_WRITE
    && type != HWBPT_EXEC
    && type != HWBPT_ANY )
      return -1;

  if ( len != 0 )
  {
    if ( len != 1                      // length is good?
      && (type == HWBPT_EXEC           // remark: instruction hardware breakpoint only accept a len of one byte
        || (len != 2 && len != 4)))
          return -1;

    if ( (ea & (len-1)) != 0 )         // alignment is good?
        return -1;
  }

  // find an empty slot
  for ( int i=0; i < MAX_BPT; i++ )
    if ( hwbpt_ea[i] == BADADDR )
      return i;

  return -1;
}

//--------------------------------------------------------------------------
int idaapi remote_is_ok_hwbpt(hwbpt_t type, ea_t ea, int len)
{
  int slot = find_hwbpt_slot(type, ea, len);
  if ( slot == -1 )
    return false;
  // give detailed answer - one bit for each bpt type
  if ( len == 0 && type == HWBPT_ANY )
    return (1 << HWBPT_EXEC)
         | (1 << HWBPT_WRITE)
         | (1 << HWBPT_RDWR);
  // give generic answer about a specific bpt type
  return true;
}

//--------------------------------------------------------------------------
static void cleanup_hwbpts(void)
{
  for ( int i=0; i < MAX_BPT; i++ )
    hwbpt_ea[i] = BADADDR;
  dr6 = 0;
  dr7 = 0x100;          // exact local breakpoints
}

