//--------------------------------------------------------------------------
static exception_info_t exceptions[] =
{
  { EXCEPTION_ACCESS_VIOLATION,         true, true, "EXCEPTION_ACCESS_VIOLATION",
    "The instruction at 0x%08a referenced memory at 0x%08lX. The memory could not be %s." },
  { EXCEPTION_DATATYPE_MISALIGNMENT,    true, true, "EXCEPTION_DATATYPE_MISALIGNMENT",
    "A datatype misalignment error was detected in a load or store instruction." },
  { EXCEPTION_BREAKPOINT,               true, true, "EXCEPTION_BREAKPOINT",              },
  { EXCEPTION_SINGLE_STEP,              true, true, "EXCEPTION_SINGLE_STEP",             },
  { EXCEPTION_ARRAY_BOUNDS_EXCEEDED,    true, true, "EXCEPTION_ARRAY_BOUNDS_EXCEEDED",
    "Array bounds exceeded." },
  { EXCEPTION_FLT_DENORMAL_OPERAND,     true, true, "EXCEPTION_FLT_DENORMAL_OPERAND",
    "Floating point denormal operand." },
  { EXCEPTION_FLT_DIVIDE_BY_ZERO,       true, true, "EXCEPTION_FLT_DIVIDE_BY_ZERO",
    "Floating point divide by zero." },
  { EXCEPTION_FLT_INEXACT_RESULT,       true, true, "EXCEPTION_FLT_INEXACT_RESULT",
    "Floating point inexact result." },
  { EXCEPTION_FLT_INVALID_OPERATION,    true, true, "EXCEPTION_FLT_INVALID_OPERATION",
    "Floating point invalid operation." },
  { EXCEPTION_FLT_OVERFLOW,             true, true, "EXCEPTION_FLT_OVERFLOW",
    "Floating point overflow." },
  { EXCEPTION_FLT_STACK_CHECK,          true, true, "EXCEPTION_FLT_STACK_CHECK",
    "Floating point stack check." },
  { EXCEPTION_FLT_UNDERFLOW,            true, true, "EXCEPTION_FLT_UNDERFLOW",
    "Floating point underflow." },
  { EXCEPTION_INT_DIVIDE_BY_ZERO,       true, true, "EXCEPTION_INT_DIVIDE_BY_ZERO",
    "Integer divide by zero." },
  { EXCEPTION_INT_OVERFLOW,             true, true, "EXCEPTION_INT_OVERFLOW",
    "Integer overflow." },
  { EXCEPTION_PRIV_INSTRUCTION,         true, true, "EXCEPTION_PRIV_INSTRUCTION",
    "Priveleged instruction." },
  { EXCEPTION_IN_PAGE_ERROR,            true, true, "EXCEPTION_IN_PAGE_ERROR",
    "The instruction at \"0x%08a\" referenced memory at \"0x%08lX\". The required data was not placed into memory because of an I/O error status of \"0x%08lX\"." },
  { EXCEPTION_ILLEGAL_INSTRUCTION,      true, true, "EXCEPTION_ILLEGAL_INSTRUCTION",
    "An attempt was made to execute an illegal instruction." },
  { EXCEPTION_NONCONTINUABLE_EXCEPTION, true, true, "EXCEPTION_NONCONTINUABLE_EXCEPTION",
    "Windows cannot continue from this exception." },
  { EXCEPTION_STACK_OVERFLOW,           true, true, "EXCEPTION_STACK_OVERFLOW",
    "A new guard page for the stack cannot be created (stack overflow)." },
  { EXCEPTION_INVALID_DISPOSITION,      true, true, "EXCEPTION_INVALID_DISPOSITION",
    "An invalid exception disposition was returned by an exception handler." },
  { EXCEPTION_GUARD_PAGE,               true, true, "EXCEPTION_GUARD_PAGE",
    "A page of memory that marks the end of a data structure, such as a stack or an array, has been accessed." },
  { EXCEPTION_INVALID_HANDLE,           true, true, "EXCEPTION_INVALID_HANDLE",
    "An invalid HANDLE was specified." },
  // Borland internal exception handling
  // All of this is just my guess (no official info)
  // NOTE: these exceptions should be the last exceptions!!!
  //       see init(): we turn off handling of all exceptions except these
#define NUM_ALWAYS 4
#define EXCEPTION_BCC_FATAL  0xEEFFACE
#define EXCEPTION_BCC_NORMAL 0xEEDFAE6
  { EXCEPTION_BCC_FATAL,                true, true, "EXCEPTION_BCC_FATAL",
    "Fatal unhandled exception in the BCC compiled program." },
  { EXCEPTION_BCC_NORMAL,               true, true, "EXCEPTION_BCC_NORMAL",
    "Unhandled exception in the BCC compiled program." },
  { DBG_CONTROL_C,                      true, true, "DBG_CONTROL_C",
    "CTRL+C was input to console process." },
  { DBG_CONTROL_BREAK,                  true, true, "DBG_CONTROL_BREAK",
    "CTRL+BREAK was input to console process." },
};

//--------------------------------------------------------------------------
static int find_signature(const uchar *sign, size_t signlen, const uchar *buf, size_t bufsize)
{
  const uchar c = sign[0];
  const uchar *end = buf + bufsize - signlen;
  for ( const uchar *ptr=buf; ptr <= end; ptr++ )
  {
    if ( *ptr != c ) continue;
    if ( memcmp(sign, ptr, signlen) == 0 )
      return ptr-buf;
  }
  return -1;
}

//--------------------------------------------------------------------------
static int find_bcc_sign(const uchar *buf, size_t bufsize)
{
  static const uchar bcc_sign[] = "fb:C++HOOK";
  int bcc_hook_off = find_signature(bcc_sign, sizeof(bcc_sign)-1, buf, bufsize);
  if ( bcc_hook_off == -1 )
    return -1;
  bcc_hook_off += sizeof(bcc_sign) - 1 + 2;
  return bcc_hook_off;
}

//--------------------------------------------------------------------------
static void fix_exception_table(ea_t begin_ea)
{
  // fix up the exceptions table according to the program type
  // for borland programs we don't intercept exceptions while for others we do
  uchar buf[4096];
  if ( rpc_get_many_bytes(begin_ea, buf, sizeof(buf))
    && find_bcc_sign(buf, sizeof(buf)) != -1 )
  {
    for ( int i=0; i < qnumber(exceptions)-NUM_ALWAYS; i++ )
    {
      exceptions[i].break_on = false;
      exceptions[i].handle   = false;
    }
  }
}

