#
#       Common part of make files for IDA.
#
#       Please set IDA and BCDIR variables!
#

#       All makesfiles are prepared to be used by BCC MAKE.EXE

#--------------------------- Main IDA directory   --------------------------
!ifndef IDA
IDA=z:\idasrc\current\  # with the trailing backslash!
#IDA=G:\IDA_SDK\		# with the trailing backslash!
!endif

!include $(IDA)makeopts.mk
!include $(IDA)defaults.mk

!ifdef __NT__
_MKFLG=-$(MAKEFLAGS)
MAKEDEFS=$(_MKFLG:--=-) $(MAKEDEFS)
!else
MAKEDEFS=$(MAKEFLAGS) $(MAKEDEFS)
!endif

!ifdef __AMD64__
__EA64__=1
!ifdef __NT__
__VC__=1
!endif
!endif

!ifdef __CEARM__
__VC__=1
!endif

!ifndef BC5_COM
BC5_COM=$(BCDIR)
!endif

ULINK_BCF=+$(ULNK_CFG_DIR)ulink.bc
ULINK_64F=+$(ULNK_CFG_DIR)ulink.vx
!ifdef VC32_USE_VC8
ULINK_VCF=+$(ULNK_CFG_DIR)ulink.v8
!else
ULINK_VCF=+$(ULNK_CFG_DIR)ulink.v6
!endif

!ifdef __AMD64__
ULNK_CFG=$(ULINK_64F)
!elseif defined(__VC__)
ULNK_CFG=$(ULINK_VCF)
!else 
ULNK_CFG=$(ULINK_BCF)
!endif

ULNK_COMPAT=-O- -o- -Gh -Gh-
!ifndef __AMD64__
ULNK_COMPAT=$(ULNK_COMPAT) -P-
!endif

ULINK=$(ULNK_BASE) $(ULNK_CFG) $(ULINK_COMPAT_OPT)

_ULCCOPT=$(_LDFLAGS) $(LNDEBUG) $(_LNK_EXE_MAP) $(_LSHOW)

!ifdef __AMD64__
!if "$(PROCESSOR_ARCHITEW6432)" != "AMD64"
NO_EXECUTE_TESTS = 1
!endif
!endif

OPTLIBDIR=$(OPTSUF)
!ifdef NDEBUG
CFGSUF=$(OPTSUF)
OBJDIRSUF=$(OPTSUF)
LIBDIRSUF=$(OPTSUF)
!else
CFGSUF=$(DEBSUF)
OBJDIRSUF=$(DEBSUF)
!ifndef USE_OPT_LIBS
LIBDIRSUF=$(DEBSUF)
!else
LIBDIRSUF=$(OPTSUF)
!endif
!endif

#-----------
!ifdef __CEARM__
LINK_NOBOR = 1
!endif
!ifdef __LINUX__
LINK_NOBOR = 1
!endif

!ifdef LINK_NOBOR
!undef LINK_ULINK
!endif

!ifdef __VC__
!ifndef LINK_ULINK
!undef LINK_NOBOR
LINK_NOBOR = 1
!endif
!endif

!ifndef LINK_NOBOR
!ifdef MAP
_LNK_EXE_MAP=-m
!else
_LNK_EXE_MAP=-x
!endif
!else               # LINK_NOBOR
!ifdef __VC__
!ifdef MAP
_LNK_EXE_MAP=/MAP
!endif
!endif
!endif

#------
!ifndef AROPT
AROPT=ru
!endif

!ifndef NOSHOW
AROPT=$(AROPT)v
!else
!ifdef __NT__
.silent
!endif
_LDSW=_q

!ifdef __VC__
_CSHOW=/nologo
!else
!ifndef __LINUX__
_CSHOW=-q
!endif
!endif

!ifndef LINK_NOBOR
_LSHOW=-q
!else
!ifndef __LINUX__
_LSHOW=/nologo
!endif
!endif

!endif   # NOSHOW

#-----------

!ifndef IDALIBS
IDALIBS=$(IDA)
!endif

######################### set TV variables
!ifndef TVSRC
TVSRC=$(IDA)ui\txt\tv\	# TurboVision subdirectory
!endif

!ifndef IDA_TVL
IDA_TVL=$(TVSRC)
!endif

!ifdef _CFLAGS_TV	# set tv path(s) for ui/txt after include defaults.mk
_CFLAGS=-I$(TVSRC)include $(_CFLAGS_TV)
!endif

############################################################################
.PHONY: all All goal Goal total Total objdir test runtest $(ADDITIONAL_GOALS)

######################### set debug switches
!ifndef NDEBUG
LNDEBUG=-v
CCDEBUG=-v
CCOPT=-O-
!ifdef __NT__
CCDEBUG=-v -D_DEBUG
!endif
!else
CCOPT=-O2
!endif

!ifdef __EA64__
SUFF64=64
ADRSIZE=64
ADRSWITCH=-D__EA64__
!else
ADRSIZE=32
!endif

# include,help and other directories are common for all platforms and compilers:
I =$(IDA)include\       # include directory
R =$(IDA)bin\		# main result directory result
HO=$(R)                 # help file is stored in the bin directory
HI=$(RS)		# _ida.hlp placed in main tool directory
C =$(R)cfg\		# cfg files stored path
RI=$(R)idc\		# idc files stored path
HS=.hls                 #       help source
HH=.hhp                 #       help headers

#############################################################################
!if $d(__MSDOS__)					# Borland C++ DOS 16
__IDA_MSDOS__=1
__DOS16__=1
IMPLIB	=$(BC31)bin\implib.exe				# implib executable name
ASM	=$(BC31)bin\tasm.exe				# assembler
!ifdef LDR_TRANSLATION
CC	=$(BCDIR)bin\bcc.exe				# C++ compiler
!else
CC	=$(BC31)bin\bcc.exe			        # C++ compiler
!endif
CFLAGS	=+$(IDA)dosbor.cfg$(CFGSUF) $(_CFLAGS) $(CCDEBUG)	# default compiler flags
AFLAGS	=/t/ml/z/m5$(_AFLAGS)				# default assembler flags
OUTSW	=-e						# outfile name switch for one-line linker
OBJSW	=-n						# object file directory switch
OUTDLL	=/Twd						# output is DLL switch
LINKER	=$(BC31)bin\tlink.exe /m $(_LDFLAGS)		# indirect file linker
CCL	=$(RS)ld $(_LDSW) _b _l$(CC) $(CFLAGS) $(_LDFLAGS)	# one-line linker
LINKSYS_EXE=      					# target link system for executable
LINKSYS	=						# target link system
C_STARTUP=$(BC31)lib\c0l				# indirect linker: C startup file
C_LIB	=$(BC31)lib\cl					# indirect linker: default C library
OVRON	=-Yo						# 16bit: following files overlayed
OVROFF	=-Yo-						# 16bit: following files not overlayed
LIBDIR	=$(IDALIBS)lib 					# libraries directory
TL	=$(IDA_TVL)lib\       		        	# TVision libraries directory
OBJDIR	=bc3.$(OBJDIRSUF)           			# object files directory
B	=.exe						# exe file extension
BS	=.exe						# host utility extension
MAP	=.map						# map file extension
T	=.ar$(LIBDIRSUF)                        	# library flag file extension
IDP	=.idp						# IDP extension
LDR     =.ldd                                           # LDR extension
PLUGIN  =.pl1                                           # PLUGIN extension
DLLEXT  =$(B)
LINKOPTS_EXE=/ye+/yx+/c
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O	=.obj						# object file extension
A	=.lib						# library file extension
IDPSTUB	=$(LIBDIR)\idpstub$(O)				# STUB file for IDPs
LDRSTUB =$(LIBDIR)\idpstub$(O) $(L)dlldata$(O)          # STUB file for LDRs
IDPSLIB =						# system libraries for IDPs
AR	=$(RS)ar$(BS) _a _e$(T) "_l$(BC31)bin\tlib.exe /C/0/E" $(AROPT)	# librarian
APISW   =-sdos16
#############################################################################
!elif $d(__AMD64__)                                     # Visual Studio 8 for AMD64
BCDIR   =$(MSVC8DIR)					#
CC      =$(BCDIR)bin$(VC8CRBIN)\cl.exe                  # C++ compiler
!ifndef NDEBUG
CCDEBUG=-D_DEBUG /Z7 /MTd
CCOPT=/Od
!else
CCOPT=/O2
!endif
CFLAGS  =@$(IDA)w64vs.cfg$(CFGSUF) $(ADRSWITCH) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CSHOW) # default compiler flags
OUTSWC  =/Fe                                            # outfile name switch for one-line linker
!ifndef LINK_ULINK
OUTSW   =/Fe                                            # outfile name switch for one-line linker
OBJSW	=/Fo						# object file directory switch
BASESW  =/BASE
OUTDLL  =/LD
LNOUTDLL=/DLL
!else
OUTSW   =-ZO
OUJSW   =-j
BASESW  =-b
LNOUTDLL=-Tpd+                                          # output is DLL(64) switch
OUTDLL  =-Tpd+     
!endif
!ifdef BASE
LDFLAGS =$(BASESW):$(BASE) $(_LDFLAGS)
!else
LDFLAGS =$(_LDFLAGS)
!endif
_LIBRTL=$(BCDIR)lib$(VC8CRLIB)
!ifndef VC8_WITHOUT_PSDK
_LIBSDK=$(BCDIR)PlatformSDK\lib$(VC8CRLIB)
NOBOR_PATH=/LIBPATH:$(_LIBSDK)
!endif
!ifdef LINK_NOBOR
LINKOPTS_EXE=/LIBPATH:$(_LIBRTL) $(NOBOR_PATH) $(_LNK_EXE_MAP) 
!else
LINKOPTS_EXE=/L$(_LIBRTL);$(_LIBSDK) $(_LNK_EXE_MAP) $(LNDEBUG)
!endif
LINKOPTS=$(LNOUTDLL) $(LINKOPTS_EXE) $(_LSHOW)
!ifndef LINK_ULINK
_LINKER =$(BCDIR)bin$(VC8CRBIN)\link.exe                # indirect file linker
_LDAD=_a"/link $(LINKOPTS_EXE)"
!else
_LINKER =$(ULINK)                                       # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(LNDEBUG) $(_LSHOW)    # default link command
!ifndef LINK_ULINK
CCL     =$(RS)ld $(_LDSW) _v $(_LDAD) _l$(CC) $(CFLAGS) $(_LDFLAGS)  # one-line linker
!else
CCL     =$(RS)ld $(_LDSW) _b _l$(ULINK) $(_ULCCOPT)
!endif
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=                                              # indirect linker: C startup file
C_IMP   =kernel32.lib                                   # import library
!ifdef NDEBUG
C_LIB   =$(C_IMP) libcmt.lib                            # indirect linker: default C library
!else
C_LIB   =$(C_IMP) libcmtd.lib                           # indirect linker: default C library
!endif
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
LIBBASE =$(IDALIBS)libvc.x64
LIBDIR  =$(LIBBASE)$(LIBDIRSUF)                         # libraries directory
TL      =$(IDA_TVL)libvc.x64$(LIBDIRSUF)\               # TVision libraries directory
OBJDIR  =vc.x64$(OBJDIRSUF)                             # object files directory
B       =x64.exe                                        # exe file extension
BS      =.exe                                           # host utility extension
MAP     =.mpv                                           # map file extension
T       =.ax64$(LIBDIRSUF)                              # library flag file extension
IDP     =.x64                                           # IDP extension
DLLEXT  =64.dll
IDP     =64.x64                                         # IDP extension
LDR     =64.x64                                         # LDR extension
PLUGIN  =.x64                                           # PLUGIN extension
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
!if  !$d(NORTL)
IDPSTUB =		                                # STUB file for IDPs
LDRSTUB =                                               # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(LIBDIR)\modstart                             # STUB file for IDPs
LDRSTUB =$(LIBDIR)\modstart                             # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _e$(T) _v _l$(BCDIR)bin$(VC8CRBIN)\lib.exe $(AROPT) # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=/TC
!endif
#############################################################################
!elif $d(__CEARM__)                                     # Visual C++ v4.0 for ARM 4.20
BCDIR   =$(MSVCARMDIR)
CC      ="$(BCDIR)bin$(ARMBINSUF)\cl$(ARMCLSUF).exe"    # C++ compiler
CCOPT=/O2
CCDEBUG=
CFLAGS  =@$(IDA)cearm.cfg$(CFGSUF) $(ADRSWITCH) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CSHOW) # default compiler flags
##CFLAG_SUFFIX = /link /subsystem:windowsce
OUTSWC  =/Fe                                            # outfile name switch for one-line linker
OUTSW   =/Fe                                            # outfile name switch for one-line linker
OBJSW	=/Fo						# object file directory switch
!ifdef BASE
LDFLAGS =/BASE:$(BASE) $(_LDFLAGS)
!else
LDFLAGS =$(_LDFLAGS)
!endif
OUTDLL  =-LD
LINKOPTS_EXE=/LIBPATH:"$(BCDIR)lib$(ARMLIBSUF)" /LIBPATH:"$(ARMSDK)lib\armv4"
LINKOPTS=$(LINKOPTS_EXE) $(_LSHOW)
_LINKER =$(BCDIR)bin$(ARMBINSUF)\link.exe               # indirect file linker
LINKER  =$(_LINKER) $(LDFLAGS) $(LNDEBUG)               # default link command
_LDAD=_a"/link /subsystem:windowsce,4.20 /machine:arm /armpadcode /LIBPATH:\"$(BCDIR)lib$(ARMLIBSUF)\" /LIBPATH:\"$(ARMSDK)lib\armv4\""
CCL     =$(RS)ld $(_LDSW) _c $(_LDAD) _l$(CC) $(CFLAGS) $(_LDFLAGS) # one-line linker
C_IMP   =corelibc.lib coredll.lib                       # import library
C_LIB   =$(C_IMP)                                       # indirect linker: default C library
LIBDIR  =$(IDALIBS)libcearm.l32$(LIBDIRSUF)             # libraries directory
OBJDIR  =armc.e32$(OBJDIRSUF)                           # object files directory
B       =_arm.exe                                       # exe file extension
BS      =.exe                                           # host utility extension
MAP     =.mparm                                         # map file extension
T       =.acearm32$(LIBDIRSUF)                          # library flag file extension
IDP     =.cearm32                                       # IDP extension
DLLEXT  =.dll
IDP     =.cearm32                                       # IDP extension
LDR     =.cearm32                                       # LDR extension
PLUGIN  =.cearm32                                       # PLUGIN extension
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
_LIBR   =$(BCDIR)bin$(ARMBINSUF)\lib.exe
AR      =$(RS)ar$(BS) _e$(T) _v "_l$(_LIBR)" $(AROPT)     # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=/TC
!endif
_ARMASM ="$(BCDIR)bin$(ARMBINSUF)\armasm.exe"
#############################################################################
!elif $d(__VC__)                                        # Visual Studio 6 for x86
!ifndef VC32_USE_VC8
BCDIR   =$(MSVC6DIR)
!else
BCDIR   =$(MSVC8DIR)	
!endif
CC      =$(BCDIR)bin\cl.exe                             # C++ compiler
!ifndef NDEBUG
!ifdef VC32_USE_VC8
CCDEBUG=-D_DEBUG /Z7 /MTd
!else
CCDEBUG=-D_DEBUG /Zi
!endif
CCOPT=/Od
!else
CCOPT=/O2
!endif
CFLAGS  =@$(IDA)w$(ADRSIZE)vs.cfg$(CFGSUF) $(ADRSWITCH) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CSHOW) # default compiler flags
OUTSWC  =/Fe                                            # outfile name switch for one-line linker
!ifndef LINK_ULINK
OUTSW   =/Fe                                            # outfile name switch for one-line linker
OBJSW	=/Fo						# object file directory switch
BASESW  =/BASE
OUTDLL  =/LD
LNOUTDLL=/DLL
!else
OUTSW   =-ZO
OUJSW   =-j
BASESW  =-b
LNOUTDLL=-Tpd                                           # output is DLL(32) switch
OUTDLL  =-Tpd      
!endif
!ifdef BASE
LDFLAGS =$(BASESW):$(BASE) $(_LDFLAGS)
!else
LDFLAGS =$(_LDFLAGS)
!endif
_LIBRTL=$(BCDIR)lib
!ifdef VC32_USE_VC8
!ifndef VC8_WITHOUT_PSDK
_LIBSDK=$(BCDIR)PlatformSDK\lib
NOBOR_PATH=/LIBPATH:$(_LIBSDK)
!endif
!endif
!ifdef LINK_NOBOR
LINKOPTS_EXE=/LIBPATH:$(_LIBRTL) $(NOBOR_PATH) $(_LNK_EXE_MAP) 
!else
LINKOPTS_EXE=/L$(_LIBRTL);$(_LIBSDK) $(_LNK_EXE_MAP) $(LNDEBUG)
!endif
LINKOPTS=$(LNOUTDLL) $(LINKOPTS_EXE) $(_LSHOW) $(LNDEBUG)
!ifndef LINK_ULINK
_LINKER =$(BCDIR)bin\link.exe                           # indirect file linker
_LDAD=_a"/link $(LINKOPTS_EXE)"
!else
_LINKER =$(ULINK)                                       # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(LNDEBUG) $(_LSHOW)    # default link command
!ifndef LINK_ULINK
CCL     =$(RS)ld $(_LDSW) _v $(_LDAD) _l$(CC) $(CFLAGS) $(_LDFLAGS)  # one-line linker
!else
CCL     =$(RS)ld $(_LDSW) _b _l$(ULINK) $(_ULCCOPT)
!endif
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=                                              # indirect linker: C startup file
C_IMP   =kernel32.lib                                   # import library
!ifdef NDEBUG
C_LIB   =$(C_IMP) libcmt.lib                            # indirect linker: default C library
!else
C_LIB   =$(C_IMP) libcmtd.lib                           # indirect linker: default C library
!endif
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
LIBBASE =$(IDALIBS)libvc.w$(ADRSIZE)
LIBDIR  =$(LIBBASE)$(LIBDIRSUF)                         # libraries directory
TL      =$(IDA_TVL)libvc.w$(ADRSIZE)$(LIBDIRSUF)\       # TVision libraries directory
OBJDIR  =vc.w$(ADRSIZE)$(OBJDIRSUF)                     # object files directory
B       =v32.exe                                        # exe file extension
BS      =.exe                                           # host utility extension
MAP     =.mpv                                           # map file extension
T       =.avc$(ADRSIZE)$(LIBDIRSUF)                     # library flag file extension
DLLEXT  =vc32.dll
IDP     =_vc32.v$(ADRSIZE)                              # IDP extension
LDR     =_vc32.v$(ADRSIZE)                              # LDR extension
PLUGIN  =.v$(ADRSIZE)                                   # PLUGIN extension
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
!if  !$d(NORTL)
IDPSTUB =                                               # STUB file for IDPs
LDRSTUB =                                               # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(LIBDIR)\modstart                             # STUB file for IDPs
LDRSTUB =$(LIBDIR)\modstart                             # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _e$(T) _v _l$(BCDIR)bin\lib.exe $(AROPT) # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=/TC
!endif
#############################################################################
!elif $d(__NT__)                                        # Borland C++ for NT (WIN32)
IMPLIB  =$(BCDIR)bin\implib.exe                         # implib executable name
ASM     =$(BC5_COM)bin\tasm32.exe                       # assembler
CC      =$(BCDIR)bin\bcc32.exe                          # C++ compiler
!ifdef __IDP__
CC_ALIGN= -ps                                           # Standard calling convention
!else
CC_ALIGN= -pr                                           # Register calling convention
!endif
!ifdef __PRECOMPILE__
CC_PRECOMPILE= -H
!endif
CFLAGS  =+$(IDA)w$(ADRSIZE)bor.cfg$(CFGSUF) $(ADRSWITCH) $(CC_PRECOMPILE) $(CC_ALIGN) $(CCDEBUG) $(CCOPT) $(_CFLAGS) $(_CSHOW) # default compiler flags
AFLAGS  =/D__FLAT__ /t/ml/m5$(_AFLAGS)                  # default assembler flags
OUTSWC  =-n -e                                          # outfile name switch for one-line linker
!ifndef LINK_ULINK
OUTSW   =-n -e                                          # outfile name switch for one-line linker
!else
OUTSW   =-ZO                                            # outfile name switch for one-line linker
!endif
OBJSW	=-n						# object file directory switch
OUTDLL  =/Tpd                                           # output is DLL switch
!ifdef BASE
NT_BSW  =-b=$(BASE)
!endif
LDFLAGS =$(NT_BSW) $(_LDFLAGS)
!ifdef LINK_ULINK
_LINKER =$(ULINK)                                       # indirect file linker
!else
_LINKER =$(BCDIR)bin\ilink32.exe -Gn                    # indirect file linker
!endif
LINKER  = $(_LINKER) $(LDFLAGS) $(LNDEBUG) $(_LSHOW)    # default link command
LINKSYS_EXE=                                            # target link system for executable
LINKSYS =                                               # target link system
C_STARTUP=c0x32                                         # indirect linker: C startup file
C_IMP   =import32.lib                                   # import library
C_LIB   =$(C_IMP) cw32mt.lib                            # indirect linker: default C library
!ifndef LINK_ULINK
CCL     =$(RS)ld $(_LDSW) _b _l$(CC) $(CFLAGS) $(_LDFLAGS)       # one-line linker
!else
CCL     =$(RS)ld $(_LDSW) _b _a"$(C_LIB)" _l$(ULINK) $(_ULCCOPT) $(C_STARTUP)
!endif
OVRON   =                                               # 16bit: following files overlayed
OVROFF  =                                               # 16bit: following files not overlayed
LIBBASE =$(IDALIBS)libbor.w$(ADRSIZE)
LIBDIR  =$(LIBBASE)$(LIBDIRSUF)                         # libraries directory
TL      =$(IDA_TVL)libbor.w32$(LIBDIRSUF)\              # TVision libraries directory
OBJDIR  =bor.w$(ADRSIZE)$(OBJDIRSUF)                    # object files directory
!ifdef __EA64__
B       =64.exe                                         # exe file extension
!else
B       =.exe                                           # exe file extension
!endif
BS      =.exe                                           # host utility extension
MAP     =.mpb                                           # map file extension
T       =.a$(ADRSIZE)$(LIBDIRSUF)                       # library flag file extension
IDP     =.w$(ADRSIZE)                                   # IDP extension
!ifdef __EA64__
DLLEXT  =64.wll
IDP     =64.w$(ADRSIZE)                                 # IDP extension
LDR     =64.l$(ADRSIZE)                                 # LDR extension
PLUGIN  =.p$(ADRSIZE)                                   # PLUGIN extension
!else
DLLEXT  =.wll
LDR     =.ldw
PLUGIN  =.plw
!endif
ORDINALS= #-o                                           # import functions by ordinals
# -c case sensitive
# -C clear state before linking
# -s detailed map of segments
# -m detailed map of publics
# -r verbose
LINKOPTS_EXE= $(_LNK_EXE_MAP) -c -C $(ORDINALS) $(LNDEBUG) -L$(BCDIR)lib
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE) $(_LSHOW)
O       =.obj                                           # object file extension
A       =.lib                                           # library file extension
!if  !$d(NORTL)
IDPSTUB =$(BCDIR)lib\c0d32                              # STUB file for IDPs
LDRSTUB =$(BCDIR)lib\c0d32                              # STUB file for LDRs
IDPSLIB =$(C_LIB)                                       # system libraries for IDPs
!else
IDPSTUB =$(LIBDIR)\modstart                             # STUB file for IDPs
LDRSTUB =$(LIBDIR)\modstart                             # STUB file for LDRs
IDPSLIB =$(C_IMP)                                       # system libraries for IDPs
!endif
AR      =$(RS)ar$(BS) _a _e$(T) "_l$(BC5_COM)bin\tlib.exe" $(AROPT) # librarian
APISW   =-swin -i$(RS)ida.imp -n
# force C mode for .c files
!if $d(DONT_FORCE_CPP)
FORCEC=-P-
!endif
#############################################################################
!else
!error          Unknown compiler/platform
!endif
#############################################################################

!if 0           # this is for makedep
F=
!else
F=$(OBJDIR)\                        # object files dir with backslash
L=$(LIBDIR)\                        # library files dir with backslash
!endif

HC=$(RS)ihc$(BS)                                # Help Compiler

IDALIB=$(L)ida$(A)
DUMB=$(L)dumb$(O)
HLIB=$(HI)_ida.hlp

########################################################################
!if   $d(__MSDOS__)
MAKEDEFS=$(MAKEDEFS) -D__MSDOS__ -U__NT__
!elif $d(__NT__)
MAKEDEFS=$(MAKEDEFS) -U__MSDOS__ -D__NT__
!else
MAKEDEFS=$(MAKEDEFS) -U__MSDOS__ -U__NT__
!endif


!ifdef __EA64__
!ifdef __AMD64__
MAKEDEFS=$(MAKEDEFS) -D__AMD64__
!else
MAKEDEFS=$(MAKEDEFS) -D__EA64__
!endif
!endif
!ifdef __VC__
MAKEDEFS=$(MAKEDEFS) -D__VC__
!endif

### for 'if exist DIRECTORY'
!IF "$(OS)" == "Windows_NT"
CHKDIR=
!ELSE
CHKDIR=/nul
!ENDIF

########################################################################
!ifndef CONLY
CONLY=-c
!endif

!ifdef __VC__
.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) /Fo$(F)${<:.cpp=.obj} $?
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) $(FORCEC) /Fo$(F)${<:.c=.obj} $?
!else
.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) $(FORCEC) {$< }
.asm$(O):
        $(ASM) $(AFLAGS) $*,$(F)$*
!endif


.hls.hhp:
        $(HC) -t $(HLIB) -i$@ $?
########################################################################
