/*
 *      Interactive disassembler (IDA)
 *      Copyright (c) 1990-98 by Ilfak Guilfanov.
 *                        E-mail: ig@datarescue.com
 *      JVM module.
 *      Copyright (c) 1995-2006 by Iouri Kharon.
 *                        E-mail: yjh@styx.cabel.net
 *
 *      ALL RIGHTS RESERVED.
 *
 */

#ifdef __BORLANDC__
#define __USELOCALES__
#endif
#ifdef __NT__
#include <windows.h>
#endif
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <pro.h>
#include "java.hpp"

typedef struct {
  wchar_t w;
  uchar   c;
  uchar   _align;
}MAP;

typedef struct {
    unsigned count;
    MAP      map[0x80];
}LOC;

static LOC lm[2];

UNIMAP unimap;  // for other locales with old bases

//--------------------------------------------------------------------------
static int NT_CDECL m_cmp(const void *p1, const void *p2)
{
    return((unsigned)((MAP*)p1)->w - ((MAP*)p2)->w);
}

//--------------------------------------------------------------------------
static char *create_map(const char *name, LOC *pl, char *ptbl)
{
  if(setlocale(LC_CTYPE, name) && MB_CUR_MAX == 1) {
    MAP m;
    m._align = 0;
    m.c = 0x80;
    int i = 0;
    do if(mbtowc(&m.w, (char*)&m.c, 1) == 1 && m.c >= 0x80) {
      pl->map[i++] = m;
      if(ptbl) {
        unimap.uchars[unimap.count++] = m.w;
        if(javaIdent(m.w)) *ptbl++ = m.c;
      }
    }while(++m.c);
    if(i > 1) qsort(pl->map, i, sizeof(m), m_cmp);
    pl->count = i;
  }
  return(ptbl);
}

//--------------------------------------------------------------------------
char *uniremap_init(char *table)
{
  const char *cur = setlocale(LC_CTYPE, NULL);
  if(!cur) cur = "C"; // PARANOYA
  cur = qstrdup(cur);

#ifdef __UNIX__
  table = create_map("", &lm[0], table);
  lm[1] = lm[0];
#else
  {
    char  s[16];
    qsnprintf(s, sizeof(s), ".%u", GetOEMCP());
    table = create_map(s, &lm[0], table);
    qsnprintf(s, sizeof(s), ".%u", GetACP());
    create_map(s, &lm[1], NULL);
  }
#endif
  setlocale(LC_CTYPE, cur); // restore default locale
  qfree((void*)cur);
  return(table);
}

//--------------------------------------------------------------------------
uchar uni_remap(ushort w)
{
  if(idpflags & IDF_ENCODING) {
    LOC *pl = lm;
    if(idpflags & IDM_OUTASM) ++pl;

    if(pl->count && w >= pl->map[0].w && w <= pl->map[pl->count-1].w) {
      MAP emp, *pm;
      emp.w = w;
      if((pm = (MAP*)bsearch(&emp, pl->map, pl->count, sizeof(MAP), m_cmp))
         != NULL) return(pm->c);
    }
  }
  return(0);
}

//--------------------------------------------------------------------------
uchar uni_remap_check(ushort w)
{
  LOC *pl = lm;

  if(pl->count && w >= pl->map[0].w && w <= pl->map[pl->count-1].w) {
    MAP emp;
    emp.w = w;
    if(bsearch(&emp, pl->map, pl->count, sizeof(MAP), m_cmp)) return(1);
  }
  return(0);
}

//--------------------------------------------------------------------------
//---------------------------------------------------------------------------
// generated by JDK1.5 (checked with beta of 1.6) -- previously version have
// some 'skipped' letters(?). See 'addonces\jvunigen.cpp' (and move headers)
uchar javaIdent(ushort v, uchar *isStart)
{
  static const uchar cpchtb[256] = {
      2,  3,  4,  5,  6,  7,  8,  9,  0, 10, 11, 12, 13, 14, 15, 16,
     17, 18, 19, 20, 21,  3, 22, 23, 24, 25,  0,  0,  0, 26, 27, 28,
     29, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     31, 32,  0,  0,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 33,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3, 34,
      3,  3,  3,  3, 35,  0,  0,  0,  0,  0,  0,  0,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
      3,  3,  3,  3,  3,  3,  3, 36,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
      0,  0,  0,  0,  0,  0,  0,  0,  0,  3, 37, 38,  3, 39, 40, 41 };

  static const uchar idxtb[42][32] = {
    {  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    {  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
       1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1 },
    {  0,  0,  0,  0,  1,  0,192,215, 38, 26, 26, 49, 38, 26, 26, 86,
       0,  0,  0,  0,  2,  3,111,  3, 26, 26,110, 26, 26, 26,110, 26 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26 },
    { 26, 26, 26, 26, 26, 26,110,  0,  0,  0, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 28, 26, 37,  0, 40, 83,  0,  0 },
    {192,192,192,192,192,192,192,192,192,192,192,222,192,192,  0,  3,
      83,  4, 26, 26, 65, 26, 26, 26, 26,110, 26, 26, 26, 26, 71, 55 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
     155,  5, 26, 26, 26, 26, 26, 26, 26,110, 26, 26, 26, 26, 96, 37 },
    { 26, 26,  0,  0,  0,  0, 38, 26, 26, 26,110, 97, 38, 26, 26, 26,
      26,  0,217,192,193,192,192,194,195,  0, 26, 26, 26, 86, 86,  0 },
    {  0,  0,224,  0, 38, 26, 26, 86, 26,154,192,228,192,156,157, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26,158,196,159,160,192,191 },
    {  0,  0,190, 26, 26, 26,192,192,192,163,  0,  0,  0,  0,  0,  0,
      26, 26, 26, 26,164,192,165,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    {166, 26, 26, 26, 26, 26, 26,189,192,224,168, 26,169,192,  0,  0,
     170, 63,  6, 26, 26, 32,  7,189,196,197,237,  8,169,192, 55,  0 },
    {170, 49,  6, 26, 26, 32,  9,171,198,197,  0, 10,216,192,172,  0,
     170, 71, 65, 26, 26, 32, 11,189,199,200,100,  0,169,192, 97,  0 },
    {170, 63,  6, 26, 26, 32, 11,189,201,197,216,  8,173,192, 97,  0,
     188, 74, 75, 12,108, 74, 71,173,202,203,237,  0,237,192,  0, 97 },
    {170, 76, 32, 26, 26, 32, 30,173,204,203,219,  0,173,192,  0,  0,
     175, 76, 32, 26, 26, 32, 30,189,204,203,219, 83,173,192,  0,  0 },
    {175, 76, 32, 26, 26, 32, 26,173,205,203,237,  0,173,192,  0,  0,
     175, 26,110,  5, 26, 26, 65, 90,110,206,207,192,  0,  0,208,  0 },
    { 38, 26, 26, 26, 26, 26,187,177,178,238,192,215,  0,  0,  0,  0,
      13, 14, 98, 38, 15, 47,187,179, 79,224,192,186,  0,  0,  0,  0 },
    {100,  0,  0,215,192,215,221,209, 26, 38, 26, 26, 26, 86,217,192,
     204, 55,192,217,192,192,192,210,211,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 65,185,202,215,192,215,164,215,  0,  0,  0,  0,
       0,  0,  0,  0, 26, 26, 26, 26, 96,  0, 26, 26, 26, 26, 26,100 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 16, 26, 26, 26, 26,
      26, 26, 26, 26, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 37 },
    {110, 26, 26, 26, 26, 26, 26, 26,110, 75,110, 75, 26, 26, 26, 26,
     110, 75, 26, 26, 26,110, 75,110, 75,110,110, 26, 26,110, 26, 26 },
    { 26,110, 75,110, 26, 26, 26, 26,110, 26, 26, 86,  0,217,215,  0,
       0,  0,  0,  0, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 40,  0 },
    { 38, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 63,110,  0,
      38, 26, 26, 86, 26, 26, 26, 26, 26, 26, 26, 26, 26, 74,100,  0 },
    { 26, 76,182,  0, 26, 26,182,  0, 26, 26,183,  0, 26, 76,184,  0,
      26, 26, 26, 26, 26, 26,181,192,192,192,180,176,192,215,  0,  0 },
    {  0,212,192,215, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,  0,
      26, 26, 26, 26, 26,174,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 40,192,241,192,241,216,192, 26, 26, 26, 96, 40,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 55,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 55, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 37 },
    { 26, 26, 96, 96, 26, 26, 26, 26, 96, 96, 26, 17, 26, 26, 26, 96,
      26, 26, 26, 26, 26, 26, 76, 79, 18, 40, 41, 55, 26, 40, 18, 40 },
    {  0,  0,  0,  0,  0,  0,  0,109,100,  0,  1,  0,  0,  0, 97,109,
       0,  0,  0,  0, 26, 26, 37,  0,  0,  0,192,210,213,214,  0,  0 },
    { 78,  5, 90, 19, 20, 21, 65, 22, 33, 37,  0,  0, 26, 26, 26, 26,
      55,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 33,  0,  0,  0, 38,167, 19, 40, 38, 26, 26, 26, 26, 26, 26, 26,
      26, 26,110,162, 38, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26 },
    { 33, 26, 26, 26, 26, 40, 38, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26,110,  0,  0, 26, 26, 26,  0,  0,  0,  0,  0,  0,  0, 26, 26 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 55,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { 26, 26, 26, 26, 26, 96, 26, 26, 26, 26, 26, 26, 26, 86,  0,  0,
       0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    {110,  0, 23,161, 26, 32,110, 79, 24, 26, 26, 26, 26, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 37,  0,  0,  0, 23, 26, 26, 26, 26, 26 },
    { 26, 26, 26, 26, 26, 26, 26, 96,  0,  0, 26, 26, 26, 26, 26, 26,
      26, 26,  5, 26, 26, 26, 26, 26, 26,  0,  0,  0,  0,  0, 26, 40 },
    {192,192,  0,  0,241,  0,108,  0,  0, 33,  0,  0,  0, 97, 76, 26,
      26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 40 },
    {  1,  0,192,215, 38, 26, 26, 49, 38, 26, 26, 86, 33, 26, 26, 26,
      26, 26, 26, 26, 26, 26, 26,110,  5,  5,  5,104, 25,  0,  0,  0 } };

  static const uchar bittb[124] = {
    0x00, 0x10, 0x3C, 0x04, 0xD7, 0xFC, 0xF9, 0xC5, 0xB0, 0x6D, 0x5E, 0xED,
    0xD6, 0x96, 0x25, 0xAE, 0x83, 0xAA, 0xDC, 0x3E, 0x50, 0xBD, 0xE3, 0xF8,
    0xDB, 0x63, 0xFF, 0x7B, 0xC3, 0xFF, 0xEF, 0xFF, 0xFD, 0xE0, 0xE6, 0xE7,
    0xFF, 0x03, 0xFE, 0xFF, 0x1F, 0xCF, 0xEE, 0xD3, 0x1F, 0xC3, 0x03, 0xEC,
    0x38, 0x87, 0xFF, 0x3B, 0x8F, 0xCF, 0x1F, 0x0F, 0x0D, 0xF6, 0x33, 0xFF,
    0xEC, 0xF3, 0xFF, 0x9F, 0xFF, 0xFB, 0xBB, 0x16, 0x9F, 0x39, 0x87, 0xBF,
    0x3B, 0x8F, 0xC7, 0x3D, 0xDF, 0xCF, 0x84, 0x5F, 0x0C, 0xC2, 0x1F, 0x40,
    0x38, 0xE2, 0x07, 0x03, 0xC0, 0xFE, 0x2F, 0x60, 0xC0, 0xA0, 0xE0, 0xE0,
    0x3F, 0x02, 0xF0, 0x03, 0x01, 0x03, 0xE0, 0x03, 0x1C, 0x03, 0x01, 0xE0,
    0x18, 0x80, 0x7F, 0x20, 0x80, 0x0F, 0x03, 0x03, 0x01, 0x06, 0x30, 0x0D,
    0xE8, 0x23, 0xFD, 0x9C };


    unsigned ind = idxtb[cpchtb[v >> 8]][((uchar)v) >> 3];
    uchar    bit = 1 << (v & 7);

    if(!(bittb[ind & 0x7F] & bit)) return(0);
    if(isStart)
      *isStart = (uchar)(   !(ind & 0x80)
                         || (!(ind & 0x40) && (bittb[ind - 68] & bit)));
    return(1);
}

//---------------------------------------------------------------------------
