#//
#// Format: (triple slashes) func=function_name entry=entry_value purge=val retval=val

#// func
#//      specifies the function name. No need to specify the module name since
#//      it is deduced from the name of the script file. The file name has
#//      always the following format: api_modulename.idc
#//
#// entry
#//      module_name.function_name means to forward to another module
#//      idc_function_name         means to call the specified IDC function
#//                                The return value of the script controls the execution:
#//                                  - zero: means to continue execution
#//                                  - non-zero: suspend the application
#//      this attribute is optional.
#//      If it is missing, a dummy stub will be generated by IDA. The next
#//      two attributes are used by the stub generator:
#// purge
#//      How many bytes to purge from the stack. Do not specify this value
#//      if you are forwarding to another module. 
#// retval
#//      The return value (this attribute is used only to generate stubs)
#//
#//

#//--------------------------------------------------------------------------
#// These are system definitions. 
#// !! Do not change them unless you know what you are doing !!
#///func=GetProcAddress entry=bochsys.BxGetProcAddress
#///func=ExitProcess entry=bochsys.BxExitProcess
#///func=GetModuleFileNameA entry=bochsys.BxGetModuleFileNameA
#///func=GetModuleHandleA entry=bochsys.BxGetModuleHandleA
#///func=VirtualAlloc entry=bochsys.BxVirtualAlloc
#///func=VirtualFree entry=bochsys.BxVirtualFree
#///func=LoadLibraryA entry=bochsys.BxLoadLibraryA
#///func=VirtualProtect entry=bochsys.BxVirtualProtect
#///func=GetTickCount entry=bochsys.BxGetTickCount
#///func=GetLastError entry=ntdll.RtlGetLastWin32Error lentry=bochsys.BxWin32GetLastError
#///func=SetLastError entry=ntdll.RtlSetLastWin32Error lentry=bochsys.BxWin32SetLastError

#// example: user dll implementation: func=GetCommandLineA entry=mydll.MyGetCommandLineA purge=0

#///func=Beep entry=beep purge=8
def beep():
  param1 = BochsGetParam(1)
  param2 = BochsGetParam(2)

  Message("I am Beep(%d, %d)\n" % (param1, param2) )

  # The emulated function returns 1:
  SetRegValue(1, "EAX")

  # Our return value controls execution of the debugged application:
  #   1 = suspend execution (inside IDACALL)
  #   0 = continue transparently
  return 0

#///func=GlobalAlloc entry=k32_GlobalAlloc purge=8
def k32_GlobalAlloc():
  # Redirect GlobalAlloc -> VirtualAlloc
  SetRegValue(BochsVirtAlloc(0, BochsGetParam(2), 1), "EAX")
  return 0

#///func=GlobalFree entry=k32_GlobalFree purge=4
def k32_GlobalFree():
  # Redirect GlobalFree -> VirtualFree
  SetRegValue(BochsVirtFree(BochsGetParam(1), 0), "EAX")
  return 0

#///func=GetCurrentThread entry=k32_GetCurrentThread purge=0
def k32_GetCurrentThread():
  SetRegValue(-2, "EAX")
  return 0

#// BOOL WINAPI WriteFile(HANDLE hFile,LPCVOID lpBuffer,DWORD nNumberOfBytesToWrite,LPDWORD lpNumberOfBytesWritten,LPOVERLAPPED lpOverlapped);
#//func=WriteFile entry=k32_writefile
#//static k32_writefile()
#//{
#//  auto fp;
#//  fp = fopen("c:\\drop.pe", "a+b");
#//  Message("fp=%d\n len=%d", fp, filelength(fp));
#//  savefile(fp, filelength(fp), BochsGetParam(2), BochsGetParam(3));
#//  fclose(fp);
#//  eax = BochsGetParam(3);
#//  return 0;
#//}