#ifndef __PC_DEBUGGER_MODULE__
#define __PC_DEBUGGER_MODULE__

#ifdef __NT__
#  include <windows.h>
#endif

#include "deb_pc.hpp"

#include "debmod.h"

class pc_debmod_t: public debmod_t
{
protected:
  //
  // Hardware breakpoints
  ea_t hwbpt_ea[MAX_BPT];
  uint32 dr6, dr7;

public:
  pc_debmod_t();
  void cleanup_hwbpts();
  virtual bool refresh_hwbpts() = 0;
  int find_hwbpt_slot(ea_t ea);
  static uchar bpt_code[X86_BPT_SIZE];
#ifdef __NT__
  bool del_hwbpt(ea_t ea);
  bool add_hwbpt(bpttype_t type, ea_t ea, int len);
  virtual bool set_hwbpts(HANDLE hThread);
  ea_t is_hwbpt_triggered(thid_t id);
  virtual HANDLE get_thread_handle(thid_t tid) = 0;
#endif

  // !! OVERRIDDEN METHODS !!
  int idaapi dbg_is_ok_bpt(bpttype_t type, ea_t ea, int len);
};

#endif
