#ifndef __RPC_HLP__
#define __RPC_HLP__

//
//
//      This file contains common RPC routines such as packet creation and parsing
//      You also find here RPC request codes and error numbers definitions
//

#include <string>
#include <ua.hpp>
#include <area.hpp>
#include <idd.hpp>
#include "consts.h"

void append_long(qstring &s, uint32 x);

inline uint32 extract_long(const uchar **ptr, const uchar *end)
{
  return unpack_dd(ptr, end);
}

inline qstring prepare_rpc_packet(uchar code)
{
  rpc_packet_t rp;
  rp.length = 0;
  rp.code   = code;
  return qstring((char *)&rp, sizeof(rp));
}

void finalize_packet(qstring &cmd);
const char *get_rpc_name(int code);

inline void append_str(qstring &s, const char *str)
{
  if ( str == NULL )
    str = "";
  size_t len = strlen(str) + 1;
  s.append(str, len);
}

char *extract_str(const uchar **ptr, const uchar *end);
void extract_memory_info(const uchar **ptr, const uchar *end, memory_info_t *info);
void append_memory_info(qstring &s, const memory_info_t *info);

inline ea_t extract_ea(const uchar **ptr, const uchar *end)
{
  return unpack_ea(ptr, end) - 1;
}

void append_ea(qstring &s, ea_t x);
void append_exception_info(qstring &s, const exception_info_t *table, int qty);
exception_info_t *extract_exception_info(const uchar **ptr, const uchar *end,int qty);

inline void extract_memory(const uchar **ptr, const uchar *end, void *buf, size_t size)
{
  if ( buf != NULL )
    memcpy(buf, *ptr, size);
  *ptr += size;
  if ( *ptr > end )
    *ptr = end;
}

inline void append_memory(qstring &s, const void *buf, size_t size)
{
  if ( size != 0 )
    s.append((char *)buf, size);
}

inline void extract_regvals(const uchar **ptr, const uchar *end, regval_t *values, int n)
{
  size_t size = sizeof(regval_t) * n;
  memcpy(values, *ptr, size);
  *ptr += size;
  if ( *ptr > end )
    *ptr = end;
}

inline void append_regvals(qstring &s, const regval_t *values, int n)
{
  s.append((char *)values, sizeof(regval_t)*n);
}

void append_debug_event(qstring &s, const debug_event_t *ev);
void extract_debug_event(const uchar **ptr, const uchar *end, debug_event_t *ev);
void extract_exception(const uchar **ptr, const uchar *end, e_exception_t *exc);
void append_exception(qstring &s, const e_exception_t *e);

inline void append_breakpoint(qstring &s, const e_breakpoint_t *info)
{
  append_ea(s, info->hea);
  append_ea(s, info->kea);
}

inline void extract_breakpoint(const uchar **ptr, const uchar *end, e_breakpoint_t *info)
{
  info->hea = extract_ea(ptr, end);
  info->kea = extract_ea(ptr, end);
}
void extract_module_info(const uchar **ptr, const uchar *end, module_info_t *info);
void append_module_info(qstring &s, const module_info_t *info);
void extract_process_info(const uchar **ptr, const uchar *end, process_info_t *info);
void append_process_info(qstring &s, const process_info_t *info);

#endif
