// read symbols from an elf file
#ifndef __SYMELF__
#define __SYMELF__

struct symbol_visitor_t
{
  // returns nonzero - stop enumeration
  virtual int visit_symbol(ea_t ea, const char *name) = 0;
  virtual int visit_interp(const char * /*name*/) { return 0; }
  virtual int visit_segment(ea_t /*start*/, size_t /*size*/, const char * /*name*/) { return 0; }
};

// returns -1 on errors
// otherwise returns the non-zero code returned by the visitor or 0
int load_elf_symbols(const char *fname, symbol_visitor_t &sv, bool remote = false);

#endif
