#ifndef __WINCE_DEBUGGER_MODULE__
#define __WINCE_DEBUGGER_MODULE__

#ifdef __NT__
#  include <windows.h>
#endif

#include "deb_arm.hpp"

#include "debmod.h"

#include "wince.hpp"

//--------------------------------------------------------------------------
class wince_debmod_t: public debmod_t
{
protected:
  bool is_xscale;
  ea_t databpts[2];
  ea_t codebpts[2];
  int dbcon;
  static int kdstub_loaded;

public:
  wince_debmod_t();
  void cleanup_hwbpts();
  virtual bool refresh_hwbpts() = 0;

  static uchar bpt_code[ARM_BPT_SIZE];

  bool del_hwbpt(ea_t ea);
  bool add_hwbpt(bpttype_t type, ea_t ea, int len);
  bool set_hwbpts(HANDLE hThread);
  ea_t is_hwbpt_triggered(thid_t id);
  virtual HANDLE get_thread_handle(thid_t tid) = 0;
  void disable_hwbpts();
  void enable_hwbpts();

  inline bool active_databpts(void)
  {
    return databpts[0] != BADADDR || databpts[1] != BADADDR;
  }

  inline bool active_codebpts(void)
  {
    return codebpts[0] != BADADDR || codebpts[1] != BADADDR;
  }

  inline bool active_hwbpts(void)
  {
    return active_databpts() || active_codebpts();
  }
  // !! OVERRIDDEN METHODS !!
  int idaapi dbg_is_ok_bpt(bpttype_t type, ea_t ea, int len);
};

#endif
